/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.CollectionJoin;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.ListJoin;
import javax.persistence.criteria.MapJoin;
import javax.persistence.criteria.PluralJoin;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.criteria.JpaSubQuery;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.domain.SqmBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedBagJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedCrossJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedEntityJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedListJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelatedSingularJoin;
import org.hibernate.query.sqm.tree.domain.SqmCorrelation;
import org.hibernate.query.sqm.tree.domain.SqmListJoin;
import org.hibernate.query.sqm.tree.domain.SqmMapJoin;
import org.hibernate.query.sqm.tree.domain.SqmSetJoin;
import org.hibernate.query.sqm.tree.domain.SqmSingularJoin;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.predicate.SqmInPredicate;
import org.hibernate.query.sqm.tree.predicate.SqmPredicate;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public class SqmSubQuery<T>
extends AbstractSqmSelectQuery<T>
implements SqmSelectQuery<T>,
JpaSubQuery<T>,
SqmExpression<T> {
    private final SqmQuery<?> parent;
    private SqmExpressable<T> expressableType;
    private String alias;

    public SqmSubQuery(SqmQuery<?> parent, SqmQueryPart<T> queryPart, Class<T> resultType, NodeBuilder builder) {
        super(queryPart, resultType, builder);
        this.parent = parent;
    }

    public SqmSubQuery(SqmQuery<?> parent, Class<T> resultType, NodeBuilder builder) {
        super(resultType, builder);
        this.parent = parent;
    }

    public SqmSubQuery(SqmQuery<?> parent, NodeBuilder builder) {
        super(null, builder);
        this.parent = parent;
    }

    public SqmQuery<?> getContainingQuery() {
        return this.parent;
    }

    public SqmSelectQuery<?> getParent() {
        return (SqmSelectQuery)this.getContainingQuery();
    }

    public String getAlias() {
        return this.alias;
    }

    @Override
    public SqmSubQuery<T> alias(String alias) {
        this.alias = alias;
        return this;
    }

    @Override
    public SqmSubQuery<T> select(Expression<T> expression) {
        ((SqmQuerySpec)this.getQuerySpec()).setSelection((JpaSelection)expression);
        return this;
    }

    @Override
    public SqmExpression<T> getSelection() {
        return (SqmExpression)super.getSelection();
    }

    public boolean isCompoundSelection() {
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().isCompoundSelection();
    }

    @Override
    public List<? extends JpaSelection<?>> getSelectionItems() {
        return null;
    }

    @Override
    public List<Selection<?>> getCompoundSelectionItems() {
        if (!this.isCompoundSelection()) {
            throw new IllegalStateException("JPA selection is not compound");
        }
        return ((SqmQuerySpec)this.getQuerySpec()).getSelection().getCompoundSelectionItems();
    }

    @Override
    public SqmSubQuery<T> distinct(boolean distinct) {
        return (SqmSubQuery)super.distinct(distinct);
    }

    @Override
    public SqmSubQuery<T> where(Expression<Boolean> restriction) {
        return (SqmSubQuery)super.where((Expression)restriction);
    }

    @Override
    public SqmSubQuery<T> where(Predicate ... restrictions) {
        return (SqmSubQuery)super.where(restrictions);
    }

    @Override
    public SqmSubQuery<T> groupBy(Expression<?> ... expressions) {
        return (SqmSubQuery)super.groupBy((Expression[])expressions);
    }

    @Override
    public SqmSubQuery<T> groupBy(List<Expression<?>> grouping) {
        return (SqmSubQuery)super.groupBy((List)grouping);
    }

    @Override
    public SqmSubQuery<T> having(Expression<Boolean> booleanExpression) {
        return (SqmSubQuery)super.having((Expression)booleanExpression);
    }

    @Override
    public SqmSubQuery<T> having(Predicate ... predicates) {
        return (SqmSubQuery)super.having(predicates);
    }

    @Override
    public <Y> SqmRoot<Y> correlate(Root<Y> parentRoot) {
        SqmCorrelation correlated = ((SqmRoot)parentRoot).createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot((SqmRoot<?>)((Object)correlated));
        }
        return correlated;
    }

    public <X, Y> SqmAttributeJoin<X, Y> correlate(Join<X, Y> join) {
        if (join instanceof PluralJoin) {
            PluralJoin pluralJoin = (PluralJoin)join;
            switch (pluralJoin.getModel().getCollectionType()) {
                case COLLECTION: {
                    return this.correlate((CollectionJoin)join);
                }
                case LIST: {
                    return this.correlate((ListJoin)join);
                }
                case SET: {
                    return this.correlate((SetJoin)join);
                }
                case MAP: {
                    return this.correlate((MapJoin)join);
                }
            }
        }
        SqmCorrelation correlated = ((SqmSingularJoin)join).createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot(((SqmCorrelatedSingularJoin)correlated).getCorrelatedRoot());
        }
        return correlated;
    }

    public <X, Y> SqmBagJoin<X, Y> correlate(CollectionJoin<X, Y> parentCollection) {
        SqmCorrelation correlated = ((SqmBagJoin)parentCollection).createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot(((SqmCorrelatedBagJoin)correlated).getCorrelatedRoot());
        }
        return correlated;
    }

    public <X, Y> SqmSetJoin<X, Y> correlate(SetJoin<X, Y> parentSet) {
        SqmCorrelation correlated = ((SqmSetJoin)parentSet).createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot(((SqmCorrelatedSetJoin)correlated).getCorrelatedRoot());
        }
        return correlated;
    }

    public <X, Y> SqmListJoin<X, Y> correlate(ListJoin<X, Y> parentList) {
        SqmCorrelation correlated = ((SqmListJoin)parentList).createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot(((SqmCorrelatedListJoin)correlated).getCorrelatedRoot());
        }
        return correlated;
    }

    public <X, K, V> SqmMapJoin<X, K, V> correlate(MapJoin<X, K, V> parentMap) {
        SqmCorrelation correlated = ((SqmMapJoin)parentMap).createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot(((SqmCorrelatedMapJoin)correlated).getCorrelatedRoot());
        }
        return correlated;
    }

    @Override
    public <X> SqmCrossJoin<X> correlate(SqmCrossJoin<X> parentCrossJoin) {
        SqmCorrelation correlated = parentCrossJoin.createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot(((SqmCorrelatedCrossJoin)correlated).getCorrelatedRoot());
        }
        return correlated;
    }

    @Override
    public <X> SqmEntityJoin<X> correlate(SqmEntityJoin<X> parentEntityJoin) {
        SqmCorrelation correlated = parentEntityJoin.createCorrelation();
        if (((SqmQuerySpec)this.getQuerySpec()).getFromClause() != null) {
            ((SqmQuerySpec)this.getQuerySpec()).getFromClause().addRoot(((SqmCorrelatedEntityJoin)correlated).getCorrelatedRoot());
        }
        return correlated;
    }

    public Set<Join<?, ?>> getCorrelatedJoins() {
        HashSet correlatedJoins = new HashSet();
        for (SqmRoot<?> root : ((SqmQuerySpec)this.getQuerySpec()).getFromClause().getRoots()) {
            if (!(root instanceof SqmCorrelation)) continue;
            for (SqmJoin sqmJoin : root.getSqmJoins()) {
                if (!(sqmJoin instanceof SqmCorrelation) || !(sqmJoin instanceof Join)) continue;
                correlatedJoins.add((Join)sqmJoin);
            }
        }
        return correlatedJoins;
    }

    @Override
    public Set<SqmJoin<?, ?>> getCorrelatedSqmJoins() {
        HashSet correlatedJoins = new HashSet();
        for (SqmRoot<?> root : ((SqmQuerySpec)this.getQuerySpec()).getFromClause().getRoots()) {
            if (!(root instanceof SqmCorrelation)) continue;
            for (SqmJoin sqmJoin : root.getSqmJoins()) {
                if (!(sqmJoin instanceof SqmCorrelation)) continue;
                correlatedJoins.add(sqmJoin);
            }
        }
        return correlatedJoins;
    }

    @Override
    public SqmPredicate isNull() {
        return this.nodeBuilder().isNull(this);
    }

    @Override
    public SqmPredicate isNotNull() {
        return this.nodeBuilder().isNotNull(this);
    }

    @Override
    public SqmInPredicate in(Object ... values) {
        return this.nodeBuilder().in((Expression)this, values);
    }

    @Override
    public SqmInPredicate in(Expression<?> ... values) {
        return this.nodeBuilder().in((Expression)this, (Expression[])values);
    }

    @Override
    public SqmInPredicate in(Collection<?> values) {
        return this.nodeBuilder().in((Expression)this, new Object[]{values});
    }

    @Override
    public SqmInPredicate in(Expression<Collection<?>> values) {
        return this.nodeBuilder().in((Expression)this, new Expression[]{values});
    }

    @Override
    public SqmExpressable<T> getNodeType() {
        return this.expressableType;
    }

    @Override
    public void applyInferableType(SqmExpressable<?> type) {
        this.expressableType = type;
        this.setResultType(type == null ? null : this.expressableType.getExpressableJavaTypeDescriptor().getJavaTypeClass());
    }

    @Override
    public SqmExpression<Long> asLong() {
        return this.castAs(StandardBasicTypes.LONG);
    }

    @Override
    public SqmExpression<Integer> asInteger() {
        return this.castAs(StandardBasicTypes.INTEGER);
    }

    @Override
    public SqmExpression<Float> asFloat() {
        return this.castAs(StandardBasicTypes.FLOAT);
    }

    @Override
    public SqmExpression<Double> asDouble() {
        return this.castAs(StandardBasicTypes.DOUBLE);
    }

    @Override
    public SqmExpression<BigDecimal> asBigDecimal() {
        return this.castAs(StandardBasicTypes.BIG_DECIMAL);
    }

    @Override
    public SqmExpression<BigInteger> asBigInteger() {
        return this.castAs(StandardBasicTypes.BIG_INTEGER);
    }

    @Override
    public SqmExpression<String> asString() {
        return this.castAs(StandardBasicTypes.STRING);
    }

    @Override
    public <X> SqmExpression<X> as(Class<X> type) {
        return this.nodeBuilder().cast((JpaExpression)this, (Class)type);
    }

    @Override
    public JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        if (this.getNodeType() == null) {
            return null;
        }
        return this.getNodeType().getExpressableJavaTypeDescriptor();
    }

    @Override
    public Class<? extends T> getJavaType() {
        return this.getResultType();
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public String asLoggableText() {
        return "<sub-query>";
    }

    public <T1> T1 accept(SemanticQueryWalker<T1> walker) {
        return walker.visitSubQueryExpression(this);
    }

    @Override
    public void appendHqlString(StringBuilder sb) {
        sb.append('(');
        super.appendHqlString(sb);
        sb.append(')');
    }
}

