/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.QueryException;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;

public class ForUpdateFragment {
    private final StringBuilder aliases = new StringBuilder();
    private final Dialect dialect;
    private final LockOptions lockOptions;

    public ForUpdateFragment(Dialect dialect, LockOptions lockOptions, Map<String, String[]> keyColumnNames) throws QueryException {
        LockMode lockMode;
        this.dialect = dialect;
        LockMode upgradeType = null;
        Iterator<Map.Entry<String, LockMode>> iter = lockOptions.getAliasLockIterator();
        this.lockOptions = lockOptions;
        if (!iter.hasNext() && LockMode.READ.lessThan(lockMode = lockOptions.getLockMode())) {
            upgradeType = lockMode;
        }
        while (iter.hasNext()) {
            Map.Entry<String, LockMode> me = iter.next();
            LockMode lockMode2 = me.getValue();
            if (!LockMode.READ.lessThan(lockMode2)) continue;
            String tableAlias = me.getKey();
            if (dialect.forUpdateOfColumns()) {
                String[] keyColumns = keyColumnNames.get(tableAlias);
                if (keyColumns == null) {
                    throw new IllegalArgumentException("alias not found: " + tableAlias);
                }
                for (String keyColumn : keyColumns = StringHelper.qualify(tableAlias, keyColumns)) {
                    this.addTableAlias(keyColumn);
                }
            } else {
                this.addTableAlias(tableAlias);
            }
            if (upgradeType != null && lockMode2 != upgradeType) {
                throw new QueryException("mixed LockModes");
            }
            upgradeType = lockMode2;
        }
    }

    public ForUpdateFragment addTableAlias(String alias) {
        if (this.aliases.length() > 0) {
            this.aliases.append(", ");
        }
        this.aliases.append(alias);
        return this;
    }

    public String toFragmentString() {
        if (this.aliases.length() == 0) {
            return this.dialect.getForUpdateString(this.lockOptions);
        }
        return this.dialect.getForUpdateString(this.aliases.toString(), this.lockOptions);
    }
}

