/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.SqlTreeCreationLogger;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTupleContainer;

public class SqlTuple
implements Expression,
SqlTupleContainer {
    private final List<? extends Expression> expressions;
    private final MappingModelExpressable valueMapping;

    public SqlTuple(List<? extends Expression> expressions, MappingModelExpressable valueMapping) {
        this.expressions = expressions;
        this.valueMapping = valueMapping;
        if (expressions.size() < 2) {
            SqlTreeCreationLogger.LOGGER.debugf("SqlTuple created with `%s` expression(s)", expressions.size());
        }
    }

    @Override
    public MappingModelExpressable getExpressionType() {
        return this.valueMapping;
    }

    public List<? extends Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTuple(this);
    }

    @Override
    public SqlTuple getSqlTuple() {
        return this;
    }

    public static class Builder {
        private final MappingModelExpressable valueMapping;
        private List<Expression> expressions;

        public Builder(MappingModelExpressable valueMapping) {
            this.valueMapping = valueMapping;
        }

        public Builder(MappingModelExpressable valueMapping, int jdbcTypeCount) {
            this(valueMapping);
            this.expressions = new ArrayList<Expression>(jdbcTypeCount);
        }

        public void addSubExpression(Expression expression) {
            if (this.expressions == null) {
                this.expressions = new ArrayList<Expression>();
            }
            this.expressions.add(expression);
        }

        public SqlTuple buildTuple() {
            return new SqlTuple(this.expressions == null ? Collections.emptyList() : this.expressions, this.valueMapping);
        }
    }
}

