/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public abstract class AbstractColumnReferenceQualifier
implements ColumnReferenceQualifier {
    protected abstract TableReference getPrimaryTableReference();

    protected abstract List<TableReferenceJoin> getTableReferenceJoins();

    protected abstract SessionFactoryImplementor getSessionFactory();

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression) {
        assert (tableExpression != null);
        TableReference tableReference = this.getTableReferenceInternal(navigablePath, tableExpression);
        if (tableReference == null) {
            throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression) {
        return this.getTableReferenceInternal(navigablePath, tableExpression);
    }

    protected TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression) {
        TableReference primaryTableReference = this.getPrimaryTableReference().getTableReference(navigablePath, tableExpression);
        if (primaryTableReference != null) {
            return primaryTableReference;
        }
        for (TableReferenceJoin tableJoin : this.getTableReferenceJoins()) {
            TableReference tableReference = tableJoin.getJoinedTableReference().getTableReference(navigablePath, tableExpression);
            if (tableReference == null) continue;
            return tableReference;
        }
        return null;
    }
}

