/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableGroupProducer;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class StandardTableGroup
extends AbstractTableGroup {
    private final TableReference primaryTableReference;
    private final Predicate<String> tableReferenceJoinNameChecker;
    private final BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator;
    private final boolean realTableGroup;
    private final boolean fetched;
    private List<TableReferenceJoin> tableJoins;

    public StandardTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, TableGroupProducer tableGroupProducer, String sourceAlias, TableReference primaryTableReference, SqlAliasBase sqlAliasBase, SessionFactoryImplementor sessionFactory) {
        super(canUseInnerJoins, navigablePath, tableGroupProducer, sourceAlias, sqlAliasBase, sessionFactory);
        this.primaryTableReference = primaryTableReference;
        this.realTableGroup = false;
        this.fetched = false;
        this.tableJoins = Collections.emptyList();
        this.tableReferenceJoinCreator = null;
        this.tableReferenceJoinNameChecker = s -> {
            for (int i = 0; i < this.tableJoins.size(); ++i) {
                if (!this.tableJoins.get(i).getJoinedTableReference().getTableExpression().equals(s)) continue;
                return true;
            }
            return false;
        };
    }

    public StandardTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, TableGroupProducer tableGroupProducer, String sourceAlias, TableReference primaryTableReference, boolean realTableGroup, SqlAliasBase sqlAliasBase, Predicate<String> tableReferenceJoinNameChecker, BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator, SessionFactoryImplementor sessionFactory) {
        super(canUseInnerJoins, navigablePath, tableGroupProducer, sourceAlias, sqlAliasBase, sessionFactory);
        this.primaryTableReference = primaryTableReference;
        this.realTableGroup = realTableGroup;
        this.fetched = false;
        this.tableJoins = null;
        this.tableReferenceJoinNameChecker = tableReferenceJoinNameChecker;
        this.tableReferenceJoinCreator = tableReferenceJoinCreator;
    }

    public StandardTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, TableGroupProducer tableGroupProducer, boolean fetched, String sourceAlias, TableReference primaryTableReference, boolean realTableGroup, SqlAliasBase sqlAliasBase, Predicate<String> tableReferenceJoinNameChecker, BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator, SessionFactoryImplementor sessionFactory) {
        super(canUseInnerJoins, navigablePath, tableGroupProducer, sourceAlias, sqlAliasBase, sessionFactory);
        this.primaryTableReference = primaryTableReference;
        this.realTableGroup = realTableGroup;
        this.fetched = fetched;
        this.tableJoins = null;
        this.tableReferenceJoinNameChecker = tableReferenceJoinNameChecker;
        this.tableReferenceJoinCreator = tableReferenceJoinCreator;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.getPrimaryTableReference().getTableExpression());
        for (TableReferenceJoin tableReferenceJoin : this.tableJoins) {
            nameCollector.accept(tableReferenceJoin.getJoinedTableReference().getTableExpression());
        }
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.primaryTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableJoins == null ? Collections.emptyList() : this.tableJoins;
    }

    @Override
    public boolean isRealTableGroup() {
        return this.realTableGroup;
    }

    @Override
    public boolean isFetched() {
        return this.fetched;
    }

    public void addTableReferenceJoin(TableReferenceJoin join) {
        if (this.tableJoins == null) {
            this.tableJoins = new ArrayList<TableReferenceJoin>();
        }
        this.tableJoins.add(join);
    }

    @Override
    public TableReference getTableReferenceInternal(NavigablePath navigablePath, String tableExpression) {
        TableReference tableReference = this.primaryTableReference.getTableReference(navigablePath, tableExpression);
        if (tableReference != null) {
            return tableReference;
        }
        if (this.tableReferenceJoinNameChecker.test(tableExpression)) {
            if (this.tableJoins != null) {
                for (int i = 0; i < this.tableJoins.size(); ++i) {
                    TableReferenceJoin join = this.tableJoins.get(i);
                    assert (join != null);
                    TableReference resolveTableReference = join.getJoinedTableReference().getTableReference(navigablePath, tableExpression);
                    if (resolveTableReference == null) continue;
                    return resolveTableReference;
                }
            }
            return this.potentiallyCreateTableReference(tableExpression);
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            TableReference primaryTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference();
            if (primaryTableReference.getTableReference(navigablePath, tableExpression) == null) continue;
            return primaryTableReference;
        }
        return null;
    }

    protected TableReference potentiallyCreateTableReference(String tableExpression) {
        TableReferenceJoin join = this.tableReferenceJoinCreator.apply(tableExpression, this);
        if (join != null) {
            this.addTableReferenceJoin(join);
            return join.getJoinedTableReference();
        }
        return null;
    }
}

