/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.from.VirtualTableGroup;

public class UnionTableGroup
implements VirtualTableGroup {
    private final boolean canUseInnerJoins;
    private final NavigablePath navigablePath;
    private List<TableGroupJoin> tableGroupJoins;
    private final UnionSubclassEntityPersister modelPart;
    private final String sourceAlias;
    private final TableReference tableReference;

    public UnionTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, TableReference tableReference, UnionSubclassEntityPersister modelPart, String sourceAlias) {
        this.canUseInnerJoins = canUseInnerJoins;
        this.navigablePath = navigablePath;
        this.tableReference = tableReference;
        this.modelPart = modelPart;
        this.sourceAlias = sourceAlias;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public ModelPart getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getGroupAlias() {
        return null;
    }

    @Override
    public ModelPartContainer getModelPart() {
        return this.modelPart;
    }

    @Override
    public String getSourceAlias() {
        return this.sourceAlias;
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptyList() : Collections.unmodifiableList(this.tableGroupJoins);
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroupJoins != null && !this.tableGroupJoins.isEmpty();
    }

    @Override
    public boolean canUseInnerJoins() {
        return this.canUseInnerJoins;
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new ArrayList<TableGroupJoin>();
        }
        if (!this.tableGroupJoins.contains(join)) {
            this.tableGroupJoins.add(join);
        }
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.tableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression) {
        return this.resolveTableReference(navigablePath, tableExpression);
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression) {
        if (this.tableReference.getTableReference(navigablePath, tableExpression) != null) {
            return this.tableReference;
        }
        if (this.tableGroupJoins != null) {
            for (TableGroupJoin tableGroupJoin : this.tableGroupJoins) {
                TableReference tableReference = tableGroupJoin.getJoinedGroup().resolveTableReference(navigablePath, tableExpression);
                if (tableReference == null) continue;
                return tableReference;
            }
        }
        return null;
    }
}

