/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.predicate;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class InListPredicate
implements Predicate {
    private final Expression testExpression;
    private final List<Expression> listExpressions;
    private final boolean negated;

    public InListPredicate(Expression testExpression) {
        this(testExpression, new ArrayList<Expression>());
    }

    public InListPredicate(Expression testExpression, boolean negated) {
        this(testExpression, new ArrayList<Expression>(), negated);
    }

    public InListPredicate(Expression testExpression, Expression ... listExpressions) {
        this(testExpression, ArrayHelper.toExpandableList(listExpressions));
    }

    public InListPredicate(Expression testExpression, List<Expression> listExpressions) {
        this(testExpression, listExpressions, false);
    }

    public InListPredicate(Expression testExpression, List<Expression> listExpressions, boolean negated) {
        this.testExpression = testExpression;
        this.listExpressions = listExpressions;
        this.negated = negated;
    }

    public Expression getTestExpression() {
        return this.testExpression;
    }

    public List<Expression> getListExpressions() {
        return this.listExpressions;
    }

    public void addExpression(Expression expression) {
        this.listExpressions.add(expression);
    }

    public boolean isNegated() {
        return this.negated;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitInListPredicate(this);
    }
}

