/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import org.hibernate.query.NullPrecedence;
import org.hibernate.query.SortOrder;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Collate;
import org.hibernate.sql.ast.tree.expression.Expression;

public class SortSpecification
implements SqlAstNode {
    private final Expression sortExpression;
    private final SortOrder sortOrder;
    private final NullPrecedence nullPrecedence;

    public SortSpecification(Expression sortExpression, String collation, SortOrder sortOrder) {
        this(sortExpression, collation, sortOrder, NullPrecedence.NONE);
    }

    public SortSpecification(Expression sortExpression, String collation, SortOrder sortOrder, NullPrecedence nullPrecedence) {
        this.sortExpression = collation == null ? sortExpression : new Collate(sortExpression, collation);
        this.sortOrder = sortOrder;
        this.nullPrecedence = nullPrecedence;
    }

    public Expression getSortExpression() {
        return this.sortExpression;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public NullPrecedence getNullPrecedence() {
        return this.nullPrecedence;
    }

    @Override
    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitSortSpecification(this);
    }
}

