/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.collection.internal;

import org.hibernate.collection.spi.CollectionSemantics;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.log.LoggingHelper;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.graph.collection.internal.AbstractCollectionInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public class DelayedCollectionInitializer
extends AbstractCollectionInitializer {
    private final DomainResultAssembler keyContainerAssembler;

    public DelayedCollectionInitializer(NavigablePath fetchedPath, PluralAttributeMapping fetchedMapping, FetchParentAccess parentAccess, DomainResultAssembler keyContainerAssembler) {
        super(fetchedPath, fetchedMapping, parentAccess);
        this.keyContainerAssembler = keyContainerAssembler;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            return;
        }
        if (!this.isAttributeAssignableToConcreteDescriptor()) {
            return;
        }
        Object parentKey = this.parentAccess.getParentKey();
        if (parentKey != null) {
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), parentKey);
            this.parentAccess.registerResolutionListener(owner -> {
                if (this.collectionInstance != null) {
                    this.collectionInstance.setOwner(owner);
                }
            });
            return;
        }
        CollectionKey loadingKey = rowProcessingState.getCollectionKey();
        if (loadingKey != null && loadingKey.getRole().equals(this.getCollectionAttributeMapping().getNavigableRole().getNavigableName())) {
            this.collectionKey = loadingKey;
            return;
        }
        JdbcValuesSourceProcessingOptions processingOptions = rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions();
        Object keyContainerValue = this.keyContainerAssembler.assemble(rowProcessingState, processingOptions);
        if (keyContainerValue != null) {
            this.collectionKey = new CollectionKey(this.collectionAttributeMapping.getCollectionDescriptor(), keyContainerValue);
            this.parentAccess.registerResolutionListener(owner -> {
                if (this.collectionInstance != null) {
                    this.collectionInstance.setOwner(owner);
                }
            });
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.collectionKey != null) {
            SharedSessionContractImplementor session = rowProcessingState.getSession();
            PersistenceContext persistenceContext = session.getPersistenceContext();
            LoadingCollectionEntry loadingEntry = persistenceContext.getLoadContexts().findLoadingCollectionEntry(this.collectionKey);
            if (loadingEntry != null) {
                this.collectionInstance = loadingEntry.getCollectionInstance();
                return;
            }
            PersistentCollection existing = persistenceContext.getCollection(this.collectionKey);
            if (existing != null) {
                this.collectionInstance = existing;
                return;
            }
            CollectionPersister collectionDescriptor = this.collectionAttributeMapping.getCollectionDescriptor();
            CollectionSemantics collectionSemantics = collectionDescriptor.getCollectionSemantics();
            Object key = this.collectionKey.getKey();
            this.collectionInstance = collectionSemantics.instantiateWrapper(key, collectionDescriptor, session);
            this.parentAccess.registerResolutionListener(owner -> this.collectionInstance.setOwner(owner));
            persistenceContext.addUninitializedCollection(collectionDescriptor, this.collectionInstance, key);
            if (collectionSemantics.getCollectionClassification() == CollectionClassification.ARRAY) {
                session.getPersistenceContext().addCollectionHolder(this.collectionInstance);
            }
        }
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
    }

    public String toString() {
        return "DelayedCollectionInitializer(" + LoggingHelper.toLoggableString(this.getNavigablePath()) + ")";
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        super.finishUpRow(rowProcessingState);
        this.collectionInstance = null;
    }
}

