/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.embeddable;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.EmbeddableMappingType;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.StateArrayContributorMapping;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.Initializer;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.embeddable.EmbeddableLoadingLogger;
import org.hibernate.sql.results.graph.embeddable.EmbeddableResultGraphNode;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.internal.NullValueAssembler;
import org.hibernate.sql.results.jdbc.spi.RowProcessingState;

public abstract class AbstractEmbeddableInitializer
extends AbstractFetchParentAccess
implements EmbeddableInitializer {
    private final NavigablePath navigablePath;
    private final EmbeddableValuedModelPart embeddedModelPartDescriptor;
    private FetchParentAccess fetchParentAccess;
    private final Map<StateArrayContributorMapping, DomainResultAssembler> assemblerMap;
    private final Object[] resolvedValues;
    private final boolean createEmptyCompositesEnabled;
    private Object compositeInstance;
    private static Supplier<Object[]> VALUE_ACCESS = () -> {
        throw new NotYetImplementedFor6Exception("Constructor value injection for embeddables not yet implemented");
    };

    public AbstractEmbeddableInitializer(EmbeddableResultGraphNode resultDescriptor, FetchParentAccess fetchParentAccess, AssemblerCreationState creationState) {
        this.navigablePath = resultDescriptor.getNavigablePath();
        this.embeddedModelPartDescriptor = resultDescriptor.getReferencedMappingContainer();
        this.fetchParentAccess = fetchParentAccess;
        EmbeddableMappingType embeddableTypeDescriptor = this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor();
        int numOfAttrs = embeddableTypeDescriptor.getNumberOfAttributeMappings();
        this.resolvedValues = new Object[numOfAttrs];
        this.assemblerMap = new IdentityHashMap<StateArrayContributorMapping, DomainResultAssembler>(numOfAttrs);
        embeddableTypeDescriptor.visitStateArrayContributors(stateArrayContributor -> {
            Fetch fetch = resultDescriptor.findFetch((Fetchable)stateArrayContributor);
            DomainResultAssembler<?> stateAssembler = fetch == null ? new NullValueAssembler(stateArrayContributor.getJavaTypeDescriptor()) : fetch.createAssembler(this, creationState);
            this.assemblerMap.put((StateArrayContributorMapping)stateArrayContributor, stateAssembler);
        });
        this.createEmptyCompositesEnabled = !"{fk}".equals(this.navigablePath.getLocalName()) && !"{id}".equals(this.navigablePath.getLocalName()) && embeddableTypeDescriptor.isCreateEmptyCompositesEnabled();
    }

    @Override
    public EmbeddableValuedModelPart getInitializedPart() {
        return this.embeddedModelPartDescriptor;
    }

    public FetchParentAccess getFetchParentAccess() {
        return this.fetchParentAccess;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Object getCompositeInstance() {
        return this.compositeInstance;
    }

    @Override
    public void resolveKey(RowProcessingState rowProcessingState) {
        if (this.compositeInstance != null) {
            return;
        }
        PropertyAccess parentInjectionPropertyAccess = this.embeddedModelPartDescriptor.getParentInjectionAttributePropertyAccess();
        FetchParentAccess fetchParentAccess = this.getFetchParentAccess();
        if (parentInjectionPropertyAccess != null && fetchParentAccess != null) {
            fetchParentAccess.findFirstEntityDescriptorAccess().registerResolutionListener(owner -> {
                if (this.compositeInstance == null) {
                    return;
                }
                parentInjectionPropertyAccess.getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
            });
        }
    }

    @Override
    public void resolveInstance(RowProcessingState rowProcessingState) {
        if (this.compositeInstance != null) {
            return;
        }
        EmbeddableMappingType embeddableTypeDescriptor = this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor();
        if (this.fetchParentAccess != null && embeddableTypeDescriptor.getMappedJavaTypeDescriptor().getJavaTypeClass().isAssignableFrom(this.fetchParentAccess.getInitializedPart().getJavaTypeDescriptor().getJavaTypeClass())) {
            this.fetchParentAccess.resolveInstance(rowProcessingState);
            this.compositeInstance = this.fetchParentAccess.getInitializedInstance();
        }
        if (this.compositeInstance == null) {
            this.compositeInstance = embeddableTypeDescriptor.getRepresentationStrategy().getInstantiator().instantiate(VALUE_ACCESS, rowProcessingState.getSession().getFactory());
        }
        EmbeddableLoadingLogger.INSTANCE.debugf("Created composite instance [%s]", (Object)this.navigablePath);
    }

    @Override
    public void initializeInstance(RowProcessingState rowProcessingState) {
        PropertyAccess parentInjectionPropertyAccess = this.embeddedModelPartDescriptor.getParentInjectionAttributePropertyAccess();
        if (parentInjectionPropertyAccess != null) {
            Object owner;
            Initializer initializer = rowProcessingState.resolveInitializer(this.navigablePath.getParent());
            if (initializer instanceof CollectionInitializer) {
                owner = ((CollectionInitializer)initializer).getCollectionInstance().getOwner();
            } else if (initializer instanceof EntityInitializer) {
                owner = ((EntityInitializer)initializer).getEntityInstance();
                parentInjectionPropertyAccess.getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
            } else {
                throw new NotYetImplementedFor6Exception(this.getClass());
            }
            parentInjectionPropertyAccess.getSetter().set(this.compositeInstance, owner, rowProcessingState.getSession().getFactory());
        }
        EmbeddableLoadingLogger.INSTANCE.debugf("Initializing composite instance [%s]", (Object)this.navigablePath);
        boolean areAllValuesNull = true;
        for (Map.Entry entry : this.assemblerMap.entrySet()) {
            Object contributorValue = ((DomainResultAssembler)entry.getValue()).assemble(rowProcessingState, rowProcessingState.getJdbcValuesSourceProcessingState().getProcessingOptions());
            this.resolvedValues[((StateArrayContributorMapping)entry.getKey()).getStateArrayPosition()] = contributorValue;
            if (contributorValue == null) continue;
            areAllValuesNull = false;
        }
        if (!this.createEmptyCompositesEnabled && areAllValuesNull) {
            this.compositeInstance = null;
        } else if (this.compositeInstance instanceof HibernateProxy) {
            Object target = this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().getRepresentationStrategy().getInstantiator().instantiate(VALUE_ACCESS, rowProcessingState.getSession().getFactory());
            this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().setPropertyValues(target, this.resolvedValues);
            ((HibernateProxy)this.compositeInstance).getHibernateLazyInitializer().setImplementation(target);
        } else if (!areAllValuesNull) {
            this.embeddedModelPartDescriptor.getEmbeddableTypeDescriptor().setPropertyValues(this.compositeInstance, this.resolvedValues);
        }
    }

    @Override
    public void finishUpRow(RowProcessingState rowProcessingState) {
        this.compositeInstance = null;
        this.clearParentResolutionListeners();
    }

    @Override
    public FetchParentAccess findFirstEntityDescriptorAccess() {
        return this.getFetchParentAccess().findFirstEntityDescriptorAccess();
    }
}

