/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity;

import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityRowIdMapping;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingType;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.EntityIdentifierNavigablePath;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.sql.ast.tree.from.LazyTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.AbstractFetchParent;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.entity.EntityResultGraphNode;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;

public abstract class AbstractEntityResultGraphNode
extends AbstractFetchParent
implements EntityResultGraphNode {
    private final EntityValuedModelPart referencedModelPart;
    private final DomainResult identifierResult;
    private final DomainResult discriminatorResult;
    private final DomainResult versionResult;
    private final DomainResult<Object> rowIdResult;
    private final EntityMappingType targetType;

    public AbstractEntityResultGraphNode(EntityValuedModelPart referencedModelPart, NavigablePath navigablePath, DomainResultCreationState creationState) {
        this(referencedModelPart, navigablePath, null, creationState);
    }

    public AbstractEntityResultGraphNode(EntityValuedModelPart referencedModelPart, NavigablePath navigablePath, EntityMappingType targetType, DomainResultCreationState creationState) {
        super(referencedModelPart.getEntityMappingType(), navigablePath);
        this.referencedModelPart = referencedModelPart;
        this.targetType = targetType;
        EntityMappingType entityDescriptor = referencedModelPart.getEntityMappingType();
        TableGroup entityTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(navigablePath);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        EntityIdentifierNavigablePath identifierNavigablePath = new EntityIdentifierNavigablePath(navigablePath, ResultsHelper.attributeName(identifierMapping));
        if (navigablePath.getParent() == null && !creationState.forceIdentifierSelection()) {
            this.identifierResult = null;
            this.visitIdentifierMapping(identifierNavigablePath, creationState, identifierMapping, entityTableGroup);
        } else {
            this.identifierResult = referencedModelPart instanceof ToOneAttributeMapping ? (((ToOneAttributeMapping)referencedModelPart).canJoinForeignKey(identifierMapping) ? ((ToOneAttributeMapping)referencedModelPart).getForeignKeyDescriptor().createKeyDomainResult(navigablePath, creationState.getSqlAstCreationState().getFromClauseAccess().findTableGroup(navigablePath.getParent()), creationState) : identifierMapping.createDomainResult(identifierNavigablePath, ((LazyTableGroup)entityTableGroup).getTableGroup(), null, creationState)) : identifierMapping.createDomainResult(identifierNavigablePath, entityTableGroup, null, creationState);
        }
        EntityDiscriminatorMapping discriminatorMapping = this.getDiscriminatorMapping(entityDescriptor, entityTableGroup);
        this.discriminatorResult = discriminatorMapping != null && entityDescriptor.getEntityPersister().getEntityMetamodel().hasSubclasses() ? discriminatorMapping.createUnderlyingDomainResult(navigablePath.append("{discriminator}"), entityTableGroup, null, creationState) : null;
        EntityVersionMapping versionDescriptor = entityDescriptor.getVersionMapping();
        this.versionResult = versionDescriptor == null ? null : versionDescriptor.createDomainResult(navigablePath.append(versionDescriptor.getFetchableName()), entityTableGroup, null, creationState);
        EntityRowIdMapping rowIdMapping = entityDescriptor.getRowIdMapping();
        this.rowIdResult = rowIdMapping == null ? null : rowIdMapping.createDomainResult(navigablePath.append(rowIdMapping.getRowIdName()), entityTableGroup, "rowid_", creationState);
    }

    private void visitIdentifierMapping(EntityIdentifierNavigablePath navigablePath, DomainResultCreationState creationState, EntityIdentifierMapping identifierMapping, TableGroup entityTableGroup) {
        MappingType mappingType = identifierMapping.getPartMappingType();
        if (mappingType instanceof ManagedMappingType) {
            ((ManagedMappingType)mappingType).visitAttributeMappings(attributeMapping -> {
                if (attributeMapping instanceof ToOneAttributeMapping) {
                    ((ToOneAttributeMapping)attributeMapping).getForeignKeyDescriptor().createKeyDomainResult(navigablePath.getParent(), entityTableGroup, creationState);
                } else {
                    attributeMapping.createDomainResult(navigablePath, entityTableGroup, null, creationState);
                }
            });
        } else {
            identifierMapping.createDomainResult(navigablePath, entityTableGroup, null, creationState);
        }
    }

    protected EntityDiscriminatorMapping getDiscriminatorMapping(EntityMappingType entityDescriptor, TableGroup entityTableGroup) {
        return entityDescriptor.getDiscriminatorMapping(entityTableGroup);
    }

    @Override
    public EntityMappingType getReferencedMappingContainer() {
        return this.getEntityValuedModelPart().getEntityMappingType();
    }

    @Override
    public EntityValuedModelPart getEntityValuedModelPart() {
        return this.referencedModelPart;
    }

    @Override
    public JavaTypeDescriptor getResultJavaTypeDescriptor() {
        return this.getEntityValuedModelPart().getEntityMappingType().getMappedJavaTypeDescriptor();
    }

    public DomainResult getIdentifierResult() {
        return this.identifierResult;
    }

    public DomainResult getDiscriminatorResult() {
        return this.discriminatorResult;
    }

    public DomainResult getVersionResult() {
        return this.versionResult;
    }

    public DomainResult<Object> getRowIdResult() {
        return this.rowIdResult;
    }
}

