/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.engine.FetchTiming;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultAssembler;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.graph.entity.internal.AbstractNonJoinedEntityFetch;
import org.hibernate.sql.results.graph.entity.internal.EntityAssembler;
import org.hibernate.sql.results.graph.entity.internal.EntityDelayedFetchInitializer;

public class EntityDelayedFetchImpl
extends AbstractNonJoinedEntityFetch {
    private final DomainResult keyResult;

    public EntityDelayedFetchImpl(FetchParent fetchParent, ToOneAttributeMapping fetchedAttribute, NavigablePath navigablePath, DomainResult keyResult) {
        super(navigablePath, fetchedAttribute, fetchParent);
        this.keyResult = keyResult;
    }

    @Override
    public FetchTiming getTiming() {
        return FetchTiming.DELAYED;
    }

    @Override
    public boolean hasTableGroup() {
        return false;
    }

    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        NavigablePath navigablePath = this.getNavigablePath();
        EntityInitializer entityInitializer = (EntityInitializer)creationState.resolveInitializer(navigablePath, this.getEntityValuedModelPart(), () -> new EntityDelayedFetchInitializer(navigablePath, this.getEntityValuedModelPart(), this.keyResult.createResultAssembler(creationState)));
        return new EntityAssembler(this.getFetchedMapping().getJavaTypeDescriptor(), entityInitializer);
    }
}

