/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.results.graph.collection.CollectionInitializer;
import org.hibernate.sql.results.graph.collection.LoadingCollectionEntry;
import org.hibernate.sql.results.internal.ResultsHelper;

public class LoadingCollectionEntryImpl
implements LoadingCollectionEntry {
    private final CollectionPersister collectionDescriptor;
    private final CollectionInitializer initializer;
    private final Object key;
    private final PersistentCollection collectionInstance;
    private List loadingState = new ArrayList();

    public LoadingCollectionEntryImpl(CollectionPersister collectionDescriptor, CollectionInitializer initializer, Object key, PersistentCollection collectionInstance) {
        this.collectionDescriptor = collectionDescriptor;
        this.initializer = initializer;
        this.key = key;
        this.collectionInstance = collectionInstance;
        collectionInstance.beforeInitialize(collectionDescriptor, -1);
        collectionInstance.beginRead();
    }

    @Override
    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public CollectionInitializer getInitializer() {
        return this.initializer;
    }

    @Override
    public Object getKey() {
        return this.key;
    }

    @Override
    public PersistentCollection getCollectionInstance() {
        return this.collectionInstance;
    }

    @Override
    public void load(Consumer<List> loadingEntryConsumer) {
        loadingEntryConsumer.accept(this.loadingState);
    }

    @Override
    public void finishLoading(ExecutionContext executionContext) {
        this.collectionInstance.injectLoadedState(this.getCollectionDescriptor().getAttributeMapping(), this.loadingState);
        boolean hasNoQueuedAdds = this.collectionInstance.endRead();
        SharedSessionContractImplementor session = executionContext.getSession();
        PersistenceContext persistenceContext = session.getPersistenceContext();
        CollectionPersister collectionDescriptor = this.getCollectionDescriptor();
        ResultsHelper.finalizeCollectionLoading(persistenceContext, collectionDescriptor, this.collectionInstance, this.getKey(), hasNoQueuedAdds);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getCollectionDescriptor().getNavigableRole().getFullPath() + "#" + this.getKey() + ")";
    }
}

