/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.jdbc.internal;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public interface ResultSetAccess
extends JdbcValuesMetadata {
    public ResultSet getResultSet();

    public SessionFactoryImplementor getFactory();

    public void release();

    @Override
    default public int getColumnCount() {
        try {
            return this.getResultSet().getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to access ResultSet column count");
        }
    }

    @Override
    default public int resolveColumnPosition(String columnName) {
        try {
            return this.getResultSet().findColumn(columnName);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column position by name");
        }
    }

    @Override
    default public String resolveColumnName(int position) {
        try {
            return this.getFactory().getJdbcServices().getJdbcEnvironment().getDialect().getColumnAliasExtractor().extractColumnAlias(this.getResultSet().getMetaData(), position);
        }
        catch (SQLException e) {
            throw this.getFactory().getJdbcServices().getJdbcEnvironment().getSqlExceptionHelper().convert(e, "Unable to find column name by position");
        }
    }

    @Override
    default public <J> BasicType<J> resolveType(int position, JavaTypeDescriptor<J> explicitJavaTypeDescriptor) {
        JdbcServices jdbcServices = this.getFactory().getJdbcServices();
        try {
            TypeConfiguration typeConfiguration = this.getFactory().getTypeConfiguration();
            ResultSetMetaData metaData = this.getResultSet().getMetaData();
            JdbcTypeDescriptor jdbcTypeDescriptor = jdbcServices.getDialect().resolveSqlTypeDescriptor(metaData.getColumnType(position), metaData.getPrecision(position), metaData.getScale(position), typeConfiguration.getJdbcTypeDescriptorRegistry());
            JavaTypeDescriptor<J> javaTypeDescriptor = explicitJavaTypeDescriptor == null ? jdbcTypeDescriptor.getJdbcRecommendedJavaTypeMapping(typeConfiguration) : explicitJavaTypeDescriptor;
            return typeConfiguration.getBasicTypeRegistry().resolve(javaTypeDescriptor, jdbcTypeDescriptor);
        }
        catch (SQLException e) {
            throw jdbcServices.getSqlExceptionHelper().convert(e, "Unable to determine JDBC type code for ResultSet position " + position);
        }
    }
}

