/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveCharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.VarcharTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class CharArrayType
extends AbstractSingleColumnStandardBasicType<char[]>
implements AdjustableBasicType<char[]> {
    public static final CharArrayType INSTANCE = new CharArrayType();

    public CharArrayType() {
        super(VarcharTypeDescriptor.INSTANCE, PrimitiveCharacterArrayTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "characters";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), "char[]", char[].class.getName()};
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaTypeDescriptor<X> domainJtd) {
        assert (domainJtd != null);
        TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
        JdbcTypeDescriptorRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeDescriptorRegistry();
        int jdbcTypeCode = indicators.isLob() ? (indicators.isNationalized() ? 2011 : 2005) : (indicators.isNationalized() ? -9 : 12);
        JdbcTypeDescriptor jdbcType = jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
        return typeConfiguration.getBasicTypeRegistry().resolve(domainJtd, jdbcType);
    }
}

