/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CharacterArrayNClobType;
import org.hibernate.type.descriptor.java.CharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.ClobTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class CharacterArrayClobType
extends AbstractSingleColumnStandardBasicType<Character[]>
implements AdjustableBasicType<Character[]> {
    public static final CharacterArrayClobType INSTANCE = new CharacterArrayClobType();

    public CharacterArrayClobType() {
        super(ClobTypeDescriptor.DEFAULT, CharacterArrayTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaTypeDescriptor<X> domainJtd) {
        if (domainJtd != null && domainJtd.getJavaTypeClass() == char[].class) {
            TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
            JdbcTypeDescriptorRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeDescriptorRegistry();
            JdbcTypeDescriptor jdbcType = indicators.isNationalized() ? jdbcTypeRegistry.getDescriptor(2011) : jdbcTypeRegistry.getDescriptor(2005);
            return typeConfiguration.getBasicTypeRegistry().resolve(typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor(domainJtd.getJavaType()), jdbcType);
        }
        return indicators.isNationalized() ? CharacterArrayNClobType.INSTANCE : this;
    }
}

