/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.CharacterArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.VarcharTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeDescriptorRegistry;
import org.hibernate.type.spi.TypeConfiguration;

public class CharacterArrayType
extends AbstractSingleColumnStandardBasicType<Character[]>
implements AdjustableBasicType<Character[]> {
    public static final CharacterArrayType INSTANCE = new CharacterArrayType();

    public CharacterArrayType() {
        super(VarcharTypeDescriptor.INSTANCE, CharacterArrayTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "wrapper-characters";
    }

    @Override
    public String[] getRegistrationKeys() {
        return new String[]{this.getName(), Character[].class.getName(), "Character[]"};
    }

    @Override
    public <X> BasicType<X> resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaTypeDescriptor<X> domainJtd) {
        TypeConfiguration typeConfiguration = indicators.getTypeConfiguration();
        JdbcTypeDescriptorRegistry jdbcTypeRegistry = typeConfiguration.getJdbcTypeDescriptorRegistry();
        int jdbcTypeCode = indicators.isLob() ? (indicators.isNationalized() ? 2011 : 2005) : (indicators.isNationalized() ? -9 : 12);
        JdbcTypeDescriptor indicatedJdbcType = jdbcTypeRegistry.getDescriptor(jdbcTypeCode);
        if (domainJtd != null && domainJtd.getJavaTypeClass() == Character[].class) {
            return typeConfiguration.getBasicTypeRegistry().resolve(typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor(domainJtd.getJavaType()), indicatedJdbcType);
        }
        if (this.getJdbcTypeDescriptor() == indicatedJdbcType) {
            return this;
        }
        return typeConfiguration.getBasicTypeRegistry().resolve(this.getJavaTypeDescriptor(), indicatedJdbcType);
    }
}

