/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.lang.reflect.Type;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BasicJavaDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.UUIDTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcLiteralFormatter;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class PostgresUUIDType
extends AbstractSingleColumnStandardBasicType<UUID> {
    public static final PostgresUUIDType INSTANCE = new PostgresUUIDType();

    public PostgresUUIDType() {
        super(PostgresUUIDJdbcTypeDescriptor.INSTANCE, UUIDTypeDescriptor.INSTANCE);
    }

    @Override
    public String getName() {
        return "pg-uuid";
    }

    @Override
    protected boolean registerUnderJavaType() {
        return true;
    }

    private static class PostgresUUIDJdbcTypeDescriptor
    implements JdbcTypeDescriptor {
        private static final PostgresUUIDJdbcTypeDescriptor INSTANCE = new PostgresUUIDJdbcTypeDescriptor();
        private static final int JDBC_TYPE_CODE = 3975;

        private PostgresUUIDJdbcTypeDescriptor() {
        }

        @Override
        public int getJdbcTypeCode() {
            return 3975;
        }

        @Override
        public boolean canBeRemapped() {
            return true;
        }

        public <J> BasicJavaDescriptor<J> getJdbcRecommendedJavaTypeMapping(TypeConfiguration typeConfiguration) {
            return (BasicJavaDescriptor)typeConfiguration.getJavaTypeDescriptorRegistry().resolveDescriptor((Type)((Object)UUID.class));
        }

        @Override
        public <T> JdbcLiteralFormatter<T> getJdbcLiteralFormatter(JavaTypeDescriptor<T> javaTypeDescriptor) {
            return null;
        }

        @Override
        public <X> ValueBinder<X> getBinder(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicBinder<X>(javaTypeDescriptor, this){

                @Override
                protected void doBindNull(PreparedStatement st, int index, WrapperOptions wrapperOptions) throws SQLException {
                    st.setNull(index, 1111);
                }

                @Override
                protected void doBind(PreparedStatement st, X value, int index, WrapperOptions wrapperOptions) throws SQLException {
                    st.setObject(index, (Object)javaTypeDescriptor.unwrap(value, UUID.class, wrapperOptions), 1111);
                }

                @Override
                protected void doBindNull(CallableStatement st, String name, WrapperOptions wrapperOptions) throws SQLException {
                    st.setNull(name, 1111);
                }

                @Override
                protected void doBind(CallableStatement st, X value, String name, WrapperOptions wrapperOptions) throws SQLException {
                    st.setObject(name, (Object)javaTypeDescriptor.unwrap(value, UUID.class, wrapperOptions), 1111);
                }
            };
        }

        @Override
        public <X> ValueExtractor<X> getExtractor(final JavaTypeDescriptor<X> javaTypeDescriptor) {
            return new BasicExtractor<X>(javaTypeDescriptor, this){

                @Override
                protected X doExtract(ResultSet rs, int position, WrapperOptions wrapperOptions) throws SQLException {
                    return javaTypeDescriptor.wrap(rs.getObject(position), wrapperOptions);
                }

                @Override
                protected X doExtract(CallableStatement statement, int position, WrapperOptions wrapperOptions) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getObject(position), wrapperOptions);
                }

                @Override
                protected X doExtract(CallableStatement statement, String name, WrapperOptions wrapperOptions) throws SQLException {
                    return javaTypeDescriptor.wrap(statement.getObject(name), wrapperOptions);
                }
            };
        }
    }
}

