/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.query.CastType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.DiscriminatorType;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.StringType;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.CharacterTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.CharTypeDescriptor;

public class TrueFalseType
extends AbstractSingleColumnStandardBasicType<Boolean>
implements PrimitiveType<Boolean>,
DiscriminatorType<Boolean>,
ConvertedBasicType<Boolean> {
    public static final TrueFalseType INSTANCE = new TrueFalseType();
    private static final TrueFalseConverter CONVERTER = new TrueFalseConverter();

    public TrueFalseType() {
        super(CharTypeDescriptor.INSTANCE, new BooleanTypeDescriptor('T', 'F'));
    }

    @Override
    public String getName() {
        return "true_false";
    }

    @Override
    public Class getPrimitiveClass() {
        return Boolean.TYPE;
    }

    @Override
    public Boolean stringToObject(String xml) throws Exception {
        return (Boolean)this.fromString(xml);
    }

    @Override
    public Serializable getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public String objectToSQLString(Boolean value, Dialect dialect) throws Exception {
        return StringType.INSTANCE.objectToSQLString(value != false ? "T" : "F", dialect);
    }

    @Override
    public CastType getCastType() {
        return CastType.TF_BOOLEAN;
    }

    @Override
    public BasicValueConverter<Boolean, ?> getValueConverter() {
        return CONVERTER;
    }

    public static class TrueFalseConverter
    implements BasicValueConverter<Boolean, Character> {
        public static final TrueFalseConverter INSTANCE = new TrueFalseConverter();

        @Override
        public Boolean toDomainValue(Character relationalForm) {
            return TrueFalseConverter.toDomain(relationalForm);
        }

        public static Boolean toDomain(Character relationalForm) {
            if (relationalForm == null) {
                return null;
            }
            if ('T' == relationalForm.charValue()) {
                return true;
            }
            if ('F' == relationalForm.charValue()) {
                return false;
            }
            return null;
        }

        @Override
        public Character toRelationalValue(Boolean domainForm) {
            return TrueFalseConverter.toRelational(domainForm);
        }

        public static Character toRelational(Boolean domainForm) {
            if (domainForm == null) {
                return null;
            }
            return Character.valueOf(domainForm != false ? (char)'T' : 'F');
        }

        @Override
        public JavaTypeDescriptor<Boolean> getDomainJavaDescriptor() {
            return BooleanTypeDescriptor.INSTANCE;
        }

        @Override
        public JavaTypeDescriptor<Character> getRelationalJavaDescriptor() {
            return CharacterTypeDescriptor.INSTANCE;
        }
    }
}

