/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTimeUtils {
    public static final String FORMAT_STRING_DATE = "yyyy-MM-dd";
    public static final String FORMAT_STRING_TIME_WITH_OFFSET = "HH:mm:ssxxx";
    public static final String FORMAT_STRING_TIME = "HH:mm:ss";
    public static final String FORMAT_STRING_TIMESTAMP = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MILLIS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MICROS = "yyyy-MM-dd HH:mm:ss.SSSSSS";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MILLIS_AND_OFFSET = "yyyy-MM-dd HH:mm:ss.SSSxxx";
    public static final String FORMAT_STRING_TIMESTAMP_WITH_MICROS_AND_OFFSET = "yyyy-MM-dd HH:mm:ss.SSSSSSxxx";
    public static final DateTimeFormatter DATE_TIME_FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIME_WITH_OFFSET = DateTimeFormatter.ofPattern("HH:mm:ssxxx", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIME = DateTimeFormatter.ofPattern("HH:mm:ss", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSS", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS_AND_OFFSET = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSxxx", Locale.ENGLISH);
    public static final DateTimeFormatter DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS_AND_OFFSET = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSSSSSxxx", Locale.ENGLISH);
    public static final String JDBC_ESCAPE_START_DATE = "{d '";
    public static final String JDBC_ESCAPE_START_TIME = "{t '";
    public static final String JDBC_ESCAPE_START_TIMESTAMP = "{ts '";
    public static final String JDBC_ESCAPE_END = "'}";
    public static final DateTimeFormatter DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendZoneOrOffsetId().optionalEnd().toFormatter();
    private static final ThreadLocal<SimpleDateFormat> LOCAL_DATE_FORMAT = ThreadLocal.withInitial(DateTimeUtils::simpleDateFormatDate);
    private static final ThreadLocal<SimpleDateFormat> LOCAL_TIME_FORMAT = ThreadLocal.withInitial(DateTimeUtils::simpleDateFormatTime);
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_WITH_MILLIS_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MILLIS, Locale.ENGLISH));
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP_WITH_MICROS_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MICROS, Locale.ENGLISH));
    public static final DateTimeFormatter OFFSET_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral(' ').optionalEnd().optionalStart().appendLiteral('T').optionalEnd().append(DateTimeFormatter.ISO_LOCAL_TIME).optionalStart().appendLiteral(' ').optionalEnd().appendOffset("+HH:mm", "+00").toFormatter();

    private DateTimeUtils() {
    }

    public static String formatAsTimestampWithMicros(TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (supportsOffset) {
                return DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS_AND_OFFSET.format(temporalAccessor);
            }
            return DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS.format(LocalDateTime.ofInstant(Instant.from(temporalAccessor), jdbcTimeZone.toZoneId()));
        }
        return DATE_TIME_FORMATTER_TIMESTAMP_WITH_MICROS.format(temporalAccessor);
    }

    public static String formatAsTimestampWithMillis(TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (supportsOffset) {
                return DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS_AND_OFFSET.format(temporalAccessor);
            }
            return DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS.format(LocalDateTime.ofInstant(Instant.from(temporalAccessor), jdbcTimeZone.toZoneId()));
        }
        return DATE_TIME_FORMATTER_TIMESTAMP_WITH_MILLIS.format(temporalAccessor);
    }

    public static String formatAsDate(TemporalAccessor temporalAccessor) {
        return DATE_TIME_FORMATTER_DATE.format(temporalAccessor);
    }

    public static String formatAsTime(TemporalAccessor temporalAccessor, boolean supportsOffset, TimeZone jdbcTimeZone) {
        if (temporalAccessor.isSupported(ChronoField.OFFSET_SECONDS)) {
            if (supportsOffset) {
                return DATE_TIME_FORMATTER_TIME_WITH_OFFSET.format(temporalAccessor);
            }
            return DATE_TIME_FORMATTER_TIME.format(LocalDateTime.ofInstant(Instant.from(temporalAccessor), jdbcTimeZone.toZoneId()));
        }
        return DATE_TIME_FORMATTER_TIME.format(temporalAccessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAsTimestampWithMillis(Date date, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MILLIS_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            String string = simpleDateFormat.format(date);
            return string;
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAsTimestampWithMicros(Date date, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MICROS_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            String string = simpleDateFormat.format(date);
            return string;
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    public static String wrapAsJdbcDateLiteral(String literal) {
        return JDBC_ESCAPE_START_DATE + literal + JDBC_ESCAPE_END;
    }

    public static String wrapAsJdbcTimeLiteral(String literal) {
        return JDBC_ESCAPE_START_TIME + literal + JDBC_ESCAPE_END;
    }

    public static String wrapAsJdbcTimestampLiteral(String literal) {
        return JDBC_ESCAPE_START_TIMESTAMP + literal + JDBC_ESCAPE_END;
    }

    public static String wrapAsAnsiDateLiteral(String literal) {
        return "date '" + literal + "'";
    }

    public static String wrapAsAnsiTimeLiteral(String literal) {
        return "time '" + literal + "'";
    }

    public static String wrapAsAnsiTimestampLiteral(String literal) {
        return "timestamp '" + literal + "'";
    }

    public static String formatAsDate(Date date) {
        return LOCAL_DATE_FORMAT.get().format(date);
    }

    public static SimpleDateFormat simpleDateFormatDate() {
        return new SimpleDateFormat(FORMAT_STRING_DATE, Locale.ENGLISH);
    }

    public static String formatAsTime(Date date) {
        return LOCAL_TIME_FORMAT.get().format(date);
    }

    public static SimpleDateFormat simpleDateFormatTime() {
        return new SimpleDateFormat(FORMAT_STRING_TIME, Locale.ENGLISH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAsTimestampWithMillis(Calendar calendar, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MILLIS_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            String string = simpleDateFormat.format(calendar.getTime());
            return string;
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    public static SimpleDateFormat simpleDateFormatTimestampWithMillis(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MILLIS, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAsTimestampWithMicros(Calendar calendar, TimeZone jdbcTimeZone) {
        SimpleDateFormat simpleDateFormat = TIMESTAMP_WITH_MICROS_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(jdbcTimeZone);
            String string = simpleDateFormat.format(calendar.getTime());
            return string;
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    public static SimpleDateFormat simpleDateFormatTimestampWithMicros(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIMESTAMP_WITH_MICROS, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAsDate(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = LOCAL_DATE_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            String string = simpleDateFormat.format(calendar.getTime());
            return string;
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    public static SimpleDateFormat simpleDateFormatDate(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_DATE, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatAsTime(Calendar calendar) {
        SimpleDateFormat simpleDateFormat = LOCAL_TIME_FORMAT.get();
        TimeZone originalTimeZone = simpleDateFormat.getTimeZone();
        try {
            simpleDateFormat.setTimeZone(calendar.getTimeZone());
            String string = simpleDateFormat.format(calendar.getTime());
            return string;
        }
        finally {
            simpleDateFormat.setTimeZone(originalTimeZone);
        }
    }

    public static SimpleDateFormat simpleDateFormatTime(TimeZone timeZone) {
        SimpleDateFormat formatter = new SimpleDateFormat(FORMAT_STRING_TIME, Locale.ENGLISH);
        formatter.setTimeZone(timeZone);
        return formatter;
    }
}

