/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.converter;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.persistence.AttributeConverter;
import javax.persistence.PersistenceException;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.jboss.logging.Logger;

public class ConvertedValueExtractor<O, R>
implements ValueExtractor<O> {
    private static final Logger log = Logger.getLogger(ConvertedValueExtractor.class);
    private final ValueExtractor<R> relationalExtractor;
    private final AttributeConverter<O, R> converter;

    public ConvertedValueExtractor(ValueExtractor<R> relationalExtractor, AttributeConverter<O, R> converter) {
        this.relationalExtractor = relationalExtractor;
        this.converter = converter;
    }

    @Override
    public O extract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
        return this.doConversion(this.relationalExtractor.extract(rs, paramIndex, options));
    }

    @Override
    public O extract(CallableStatement statement, int paramIndex, WrapperOptions options) throws SQLException {
        return this.doConversion(this.relationalExtractor.extract(statement, paramIndex, options));
    }

    @Override
    public O extract(CallableStatement statement, String paramName, WrapperOptions options) throws SQLException {
        return this.doConversion(this.relationalExtractor.extract(statement, paramName, options));
    }

    private O doConversion(R extractedValue) {
        try {
            Object convertedValue = this.converter.convertToEntityAttribute(extractedValue);
            log.debugf("Converted value on extraction: %s -> %s", extractedValue, convertedValue);
            return (O)convertedValue;
        }
        catch (PersistenceException pe) {
            throw pe;
        }
        catch (RuntimeException re) {
            throw new PersistenceException("Error attempting to apply AttributeConverter", (Throwable)re);
        }
    }
}

