/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.time.Duration;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassTypeDescriptor;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;
import org.hibernate.type.descriptor.jdbc.NumericTypeDescriptor;

public class DurationJavaDescriptor
extends AbstractClassTypeDescriptor<Duration> {
    public static final DurationJavaDescriptor INSTANCE = new DurationJavaDescriptor();

    public DurationJavaDescriptor() {
        super(Duration.class, ImmutableMutabilityPlan.INSTANCE);
    }

    @Override
    public JdbcTypeDescriptor getRecommendedJdbcType(JdbcTypeDescriptorIndicators context) {
        return NumericTypeDescriptor.INSTANCE;
    }

    @Override
    public String toString(Duration value) {
        if (value == null) {
            return null;
        }
        String seconds = String.valueOf(value.getSeconds());
        String nanos = String.valueOf(value.getNano());
        String zeros = StringHelper.repeat('0', 9 - nanos.length());
        return seconds + zeros + nanos;
    }

    @Override
    public Duration fromString(String string) {
        if (string == null) {
            return null;
        }
        int cutoff = string.length() - 9;
        return Duration.ofSeconds(Long.parseLong(string.substring(0, cutoff)), Long.parseLong(string.substring(cutoff)));
    }

    @Override
    public <X> X unwrap(Duration duration, Class<X> type, WrapperOptions options) {
        if (duration == null) {
            return null;
        }
        if (Duration.class.isAssignableFrom(type)) {
            return (X)duration;
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)new BigDecimal(duration.getSeconds()).movePointRight(9).add(new BigDecimal(duration.getNano()));
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)duration.toString();
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(duration.toNanos());
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Duration wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Duration.class.isInstance(value)) {
            return (Duration)value;
        }
        if (BigDecimal.class.isInstance(value)) {
            BigDecimal[] secondsAndNanos = ((BigDecimal)value).divideAndRemainder(BigDecimal.ONE.movePointRight(9));
            return Duration.ofSeconds(secondsAndNanos[0].longValueExact(), secondsAndNanos[1].intValue());
        }
        if (Long.class.isInstance(value)) {
            return Duration.ofNanos((Long)value);
        }
        if (String.class.isInstance(value)) {
            return Duration.parse((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return Math.min(21, dialect.getDefaultDecimalPrecision());
    }

    @Override
    public int getDefaultSqlScale() {
        return 0;
    }
}

