/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassTypeDescriptor;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.CoercionHelper;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.spi.Primitive;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;

public class FloatTypeDescriptor
extends AbstractClassTypeDescriptor<Float>
implements Primitive<Float> {
    public static final FloatTypeDescriptor INSTANCE = new FloatTypeDescriptor();

    public FloatTypeDescriptor() {
        super(Float.class);
    }

    @Override
    public JdbcTypeDescriptor getRecommendedJdbcType(JdbcTypeDescriptorIndicators indicators) {
        return org.hibernate.type.descriptor.jdbc.FloatTypeDescriptor.INSTANCE;
    }

    @Override
    public String toString(Float value) {
        return value == null ? null : value.toString();
    }

    @Override
    public Float fromString(String string) {
        return Float.valueOf(string);
    }

    @Override
    public <X> X unwrap(Float value, Class<X> type, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Float.class.isAssignableFrom(type)) {
            return (X)value;
        }
        if (Byte.class.isAssignableFrom(type)) {
            return (X)Byte.valueOf(value.byteValue());
        }
        if (Short.class.isAssignableFrom(type)) {
            return (X)Short.valueOf(value.shortValue());
        }
        if (Integer.class.isAssignableFrom(type)) {
            return (X)Integer.valueOf(value.intValue());
        }
        if (Long.class.isAssignableFrom(type)) {
            return (X)Long.valueOf(value.longValue());
        }
        if (Double.class.isAssignableFrom(type)) {
            return (X)Double.valueOf(value.doubleValue());
        }
        if (BigInteger.class.isAssignableFrom(type)) {
            return (X)BigInteger.valueOf(value.longValue());
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return (X)BigDecimal.valueOf(value.floatValue());
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)value.toString();
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> Float wrap(X value, WrapperOptions options) {
        if (value == null) {
            return null;
        }
        if (Float.class.isInstance(value)) {
            return (Float)value;
        }
        if (Number.class.isInstance(value)) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (String.class.isInstance(value)) {
            return Float.valueOf((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public Class getPrimitiveClass() {
        return Float.TYPE;
    }

    @Override
    public Class<Float[]> getArrayClass() {
        return Float[].class;
    }

    @Override
    public Class<?> getPrimitiveArrayClass() {
        return float[].class;
    }

    @Override
    public Float getDefaultValue() {
        return Float.valueOf(0.0f);
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect) {
        return 14L;
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect) {
        return dialect.getFloatPrecision();
    }

    @Override
    public <X> Float coerce(X value, JavaTypeDescriptor.CoercionContext coercionContext) {
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof Double) {
            return Float.valueOf(((Double)value).floatValue());
        }
        if (value instanceof Byte) {
            return Float.valueOf(((Byte)value).floatValue());
        }
        if (value instanceof Short) {
            return Float.valueOf(((Short)value).floatValue());
        }
        if (value instanceof Integer) {
            return Float.valueOf(((Integer)value).floatValue());
        }
        if (value instanceof Long) {
            return Float.valueOf(((Long)value).floatValue());
        }
        if (value instanceof BigInteger) {
            return Float.valueOf(((BigInteger)value).floatValue());
        }
        if (value instanceof BigDecimal) {
            return Float.valueOf(((BigDecimal)value).floatValue());
        }
        if (value instanceof String) {
            return CoercionHelper.coerceWrappingError(() -> Float.valueOf(Float.parseFloat((String)value)));
        }
        throw new CoercionException(String.format(Locale.ROOT, "Cannot coerce value `%s` [%s] as Float", value, value.getClass().getName()));
    }
}

