/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.java;

import java.time.ZoneOffset;
import java.util.Comparator;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.AbstractClassTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;

public class ZoneOffsetJavaDescriptor
extends AbstractClassTypeDescriptor<ZoneOffset> {
    public static final ZoneOffsetJavaDescriptor INSTANCE = new ZoneOffsetJavaDescriptor();

    public ZoneOffsetJavaDescriptor() {
        super(ZoneOffset.class);
    }

    @Override
    public String toString(ZoneOffset value) {
        return value.getId();
    }

    @Override
    public ZoneOffset fromString(String string) {
        return ZoneOffset.of(string);
    }

    @Override
    public JdbcTypeDescriptor getRecommendedJdbcType(JdbcTypeDescriptorIndicators context) {
        return StringTypeDescriptor.INSTANCE.getRecommendedJdbcType(context);
    }

    @Override
    public Comparator<ZoneOffset> getComparator() {
        return ZoneOffsetComparator.INSTANCE;
    }

    @Override
    public <X> X unwrap(ZoneOffset value, Class<X> type, WrapperOptions wrapperOptions) {
        if (value == null) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (X)this.toString(value);
        }
        throw this.unknownUnwrap(type);
    }

    @Override
    public <X> ZoneOffset wrap(X value, WrapperOptions wrapperOptions) {
        if (value == null) {
            return null;
        }
        if (String.class.isInstance(value)) {
            return this.fromString((String)value);
        }
        throw this.unknownWrap(value.getClass());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect) {
        return 6L;
    }

    public static class ZoneOffsetComparator
    implements Comparator<ZoneOffset> {
        public static final ZoneOffsetComparator INSTANCE = new ZoneOffsetComparator();

        @Override
        public int compare(ZoneOffset o1, ZoneOffset o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

