/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.descriptor.jdbc;

import java.io.Serializable;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.type.descriptor.ValueBinder;
import org.hibernate.type.descriptor.ValueExtractor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.BasicBinder;
import org.hibernate.type.descriptor.jdbc.BasicExtractor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.VarbinaryTypeDescriptor;

public class ObjectJdbcTypeDescriptor
implements JdbcTypeDescriptor {
    public static final ObjectJdbcTypeDescriptor INSTANCE = new ObjectJdbcTypeDescriptor(2000);
    private final int jdbcTypeCode;

    public ObjectJdbcTypeDescriptor(int jdbcTypeCode) {
        this.jdbcTypeCode = jdbcTypeCode;
    }

    @Override
    public int getJdbcTypeCode() {
        return this.jdbcTypeCode;
    }

    public String toString() {
        return "ObjectSqlTypeDescriptor(" + this.jdbcTypeCode + ")";
    }

    @Override
    public boolean canBeRemapped() {
        return true;
    }

    @Override
    public <X> ValueBinder<X> getBinder(JavaTypeDescriptor<X> javaTypeDescriptor) {
        if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
            return VarbinaryTypeDescriptor.INSTANCE.getBinder(javaTypeDescriptor);
        }
        return new BasicBinder<X>(javaTypeDescriptor, this){

            @Override
            protected void doBind(PreparedStatement st, X value, int index, WrapperOptions options) throws SQLException {
                st.setObject(index, value, ObjectJdbcTypeDescriptor.this.jdbcTypeCode);
            }

            @Override
            protected void doBind(CallableStatement st, X value, String name, WrapperOptions options) throws SQLException {
                st.setObject(name, value, ObjectJdbcTypeDescriptor.this.jdbcTypeCode);
            }
        };
    }

    public ValueExtractor getExtractor(JavaTypeDescriptor javaTypeDescriptor) {
        if (Serializable.class.isAssignableFrom(javaTypeDescriptor.getJavaTypeClass())) {
            return VarbinaryTypeDescriptor.INSTANCE.getExtractor(javaTypeDescriptor);
        }
        return new BasicExtractor(javaTypeDescriptor, this){

            protected Object doExtract(ResultSet rs, int paramIndex, WrapperOptions options) throws SQLException {
                return rs.getObject(paramIndex);
            }

            protected Object doExtract(CallableStatement statement, int index, WrapperOptions options) throws SQLException {
                return statement.getObject(index);
            }

            protected Object doExtract(CallableStatement statement, String name, WrapperOptions options) throws SQLException {
                return statement.getObject(name);
            }
        };
    }
}

