/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.query.CastType;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.AdjustableBasicType;
import org.hibernate.type.BasicType;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptor;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;

public class StandardBasicTypeImpl<J>
extends AbstractSingleColumnStandardBasicType
implements AdjustableBasicType {
    public static final String[] NO_REG_KEYS = ArrayHelper.EMPTY_STRING_ARRAY;

    public StandardBasicTypeImpl(JavaTypeDescriptor<J> jtd, JdbcTypeDescriptor std) {
        super(std, jtd);
    }

    @Override
    public String[] getRegistrationKeys() {
        return NO_REG_KEYS;
    }

    @Override
    public String getName() {
        return null;
    }

    public BasicType resolveIndicatedType(JdbcTypeDescriptorIndicators indicators, JavaTypeDescriptor domainJtd) {
        JdbcTypeDescriptor recommendedSqlType = this.getJavaTypeDescriptor().getRecommendedJdbcType(indicators);
        if (recommendedSqlType == this.getJdbcTypeDescriptor()) {
            return this;
        }
        return indicators.getTypeConfiguration().getBasicTypeRegistry().resolve(this.getJavaTypeDescriptor(), recommendedSqlType);
    }

    @Override
    public CastType getCastType() {
        if (this.getJavaTypeDescriptor() == BooleanTypeDescriptor.INSTANCE) {
            switch (this.getJdbcTypeCode()) {
                case -7: 
                case -6: 
                case 4: 
                case 5: {
                    return CastType.INTEGER_BOOLEAN;
                }
                case 1: {
                    return CastType.YN_BOOLEAN;
                }
            }
        }
        return super.getCastType();
    }
}

