/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.jaxb.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.transform.dom.DOMSource;
import org.hibernate.boot.MappingNotFoundException;
import org.hibernate.boot.archive.spi.InputStreamAccess;
import org.hibernate.boot.jaxb.JaxbLogger;
import org.hibernate.boot.jaxb.Origin;
import org.hibernate.boot.jaxb.SourceType;
import org.hibernate.boot.jaxb.internal.CacheableFileXmlSource;
import org.hibernate.boot.jaxb.internal.FileXmlSource;
import org.hibernate.boot.jaxb.internal.InputStreamAccessXmlSource;
import org.hibernate.boot.jaxb.internal.InputStreamXmlSource;
import org.hibernate.boot.jaxb.internal.JarFileEntryXmlSource;
import org.hibernate.boot.jaxb.internal.JaxpSourceXmlSource;
import org.hibernate.boot.jaxb.internal.UrlXmlSource;
import org.hibernate.boot.jaxb.spi.XmlSource;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.w3c.dom.Document;

public class XmlSources {
    public static XmlSource fromResource(String resourceName, ClassLoaderService classLoaderService) {
        JaxbLogger.JAXB_LOGGER.tracef("reading mappings from resource : %s", resourceName);
        Origin origin = new Origin(SourceType.RESOURCE, resourceName);
        URL url = classLoaderService.locateResource(resourceName);
        if (url == null) {
            throw new MappingNotFoundException(origin);
        }
        return new UrlXmlSource(origin, url);
    }

    public static XmlSource fromUrl(URL url) {
        String urlExternalForm = url.toExternalForm();
        JaxbLogger.JAXB_LOGGER.tracef("Reading mapping document from URL : %s", urlExternalForm);
        Origin origin = new Origin(SourceType.URL, urlExternalForm);
        return new UrlXmlSource(origin, url);
    }

    public static XmlSource fromFile(File file) {
        String filePath = file.getPath();
        JaxbLogger.JAXB_LOGGER.tracef("reading mappings from file : %s", filePath);
        Origin origin = new Origin(SourceType.FILE, filePath);
        if (!file.exists()) {
            throw new MappingNotFoundException(origin);
        }
        return new FileXmlSource(origin, file);
    }

    public static XmlSource fromCacheableFile(File file) {
        return XmlSources.fromCacheableFile(file, file.getParentFile());
    }

    public static XmlSource fromCacheableFile(File file, File cacheableDir) {
        return XmlSources.fromCacheableFile(file, cacheableDir, false);
    }

    public static XmlSource fromCacheableFile(File file, boolean strict) {
        return XmlSources.fromCacheableFile(file, file.getParentFile(), strict);
    }

    public static XmlSource fromCacheableFile(File file, File cacheableDir, boolean strict) {
        String filePath = file.getPath();
        JaxbLogger.JAXB_LOGGER.tracef("reading mappings from cacheable-file : %s", filePath);
        Origin origin = new Origin(SourceType.FILE, filePath);
        return new CacheableFileXmlSource(origin, file, cacheableDir, strict);
    }

    public static XmlSource fromStream(InputStreamAccess inputStreamAccess) {
        String streamName = inputStreamAccess.getStreamName();
        JaxbLogger.JAXB_LOGGER.tracef("reading mappings from InputStreamAccess : %s", streamName);
        Origin origin = new Origin(SourceType.INPUT_STREAM, streamName);
        return new InputStreamAccessXmlSource(origin, inputStreamAccess);
    }

    public static XmlSource fromStream(InputStream inputStream) {
        JaxbLogger.JAXB_LOGGER.trace("reading mappings from InputStream");
        Origin origin = new Origin(SourceType.INPUT_STREAM, null);
        return new InputStreamXmlSource(origin, inputStream, false);
    }

    public static XmlSource fromDocument(Document document) {
        JaxbLogger.JAXB_LOGGER.trace("reading mappings from DOM");
        Origin origin = new Origin(SourceType.DOM, "<unknown>");
        return new JaxpSourceXmlSource(origin, new DOMSource(document));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fromJar(File jar, Consumer<XmlSource> consumer) {
        JaxbLogger.JAXB_LOGGER.tracef("Seeking mapping documents in jar file : %s", jar.getName());
        Origin origin = new Origin(SourceType.JAR, jar.getAbsolutePath());
        try {
            JarFile jarFile = new JarFile(jar);
            try {
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    JarEntry jarEntry = entries.nextElement();
                    if (!jarEntry.getName().endsWith(".hbm.xml")) continue;
                    JaxbLogger.JAXB_LOGGER.tracef("Found hbm.xml mapping in jar : %s", jarEntry.getName());
                    consumer.accept(new JarFileEntryXmlSource(origin, jarFile, jarEntry));
                }
            }
            finally {
                try {
                    jarFile.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (IOException e) {
            throw new MappingNotFoundException(e, origin);
        }
    }
}

