/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.process.internal;

import org.hibernate.boot.model.process.internal.ValueConverterTypeAdapter;
import org.hibernate.mapping.BasicValue;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.convert.spi.BasicValueConverter;
import org.hibernate.type.BasicType;
import org.hibernate.type.ConvertedBasicType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeDescriptorIndicators;

public class ConvertedBasicTypeResolution<J>
implements BasicValue.Resolution<J> {
    private final ConvertedBasicType basicType;
    private final ValueConverterTypeAdapter adapted;

    public ConvertedBasicTypeResolution(ConvertedBasicType basicType, JdbcTypeDescriptorIndicators stdIndicators) {
        this.basicType = basicType;
        BasicValueConverter valueConverter = basicType.getValueConverter();
        this.adapted = new ValueConverterTypeAdapter(valueConverter.getClass().getTypeName(), valueConverter, stdIndicators);
    }

    @Override
    public BasicType<J> getLegacyResolvedBasicType() {
        return this.adapted;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.adapted;
    }

    @Override
    public JavaType<J> getDomainJavaDescriptor() {
        return this.basicType.getValueConverter().getDomainJavaDescriptor();
    }

    @Override
    public JavaType<?> getRelationalJavaDescriptor() {
        return this.basicType.getValueConverter().getRelationalJavaDescriptor();
    }

    @Override
    public JdbcType getJdbcTypeDescriptor() {
        return this.adapted.getJdbcTypeDescriptor();
    }

    @Override
    public BasicValueConverter getValueConverter() {
        return this.basicType.getValueConverter();
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.getDomainJavaDescriptor().getMutabilityPlan();
    }
}

