/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import jakarta.xml.bind.JAXBElement;
import java.io.Serializable;
import java.util.Locale;
import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedNativeQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNamedQueryType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryCollectionLoadReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryJoinReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmNativeQueryScalarReturnType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmQueryParamType;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmSynchronizeType;
import org.hibernate.boot.model.source.internal.hbm.HbmLocalMetadataBuildingContext;
import org.hibernate.boot.query.ImplicitHbmResultSetMappingDescriptorBuilder;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinitionBuilder;
import org.hibernate.internal.log.DeprecationLogger;
import org.hibernate.internal.util.StringHelper;

public class NamedQueryBinder {
    public static void processNamedQuery(HbmLocalMetadataBuildingContext context, JaxbHbmNamedQueryType namedQueryBinding) {
        NamedQueryBinder.processNamedQuery(context, namedQueryBinding, "");
    }

    public static void processNamedQuery(HbmLocalMetadataBuildingContext context, JaxbHbmNamedQueryType namedQueryBinding, String prefix) {
        String registrationName = prefix + namedQueryBinding.getName();
        NamedHqlQueryDefinition.Builder queryBuilder = (NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(registrationName).setComment(namedQueryBinding.getComment())).setCacheable(namedQueryBinding.isCacheable())).setCacheMode(namedQueryBinding.getCacheMode())).setCacheRegion(namedQueryBinding.getCacheRegion())).setTimeout(namedQueryBinding.getTimeout())).setReadOnly(namedQueryBinding.isReadOnly())).setFlushMode(namedQueryBinding.getFlushMode())).setFetchSize(namedQueryBinding.getFetchSize());
        boolean foundQuery = false;
        for (Serializable content : namedQueryBinding.getContent()) {
            if (content instanceof String) {
                String hqlString = StringHelper.nullIfEmpty(((String)((Object)content)).trim());
                if (!StringHelper.isNotEmpty(hqlString)) continue;
                queryBuilder.setHqlString(hqlString);
                foundQuery = true;
                continue;
            }
            JaxbHbmQueryParamType paramTypeBinding = (JaxbHbmQueryParamType)((JAXBElement)content).getValue();
            queryBuilder.addParameterTypeHint(paramTypeBinding.getName(), paramTypeBinding.getType());
        }
        if (!foundQuery) {
            throw new MappingException(String.format("Named query [%s] did not specify query string", namedQueryBinding.getName()), context.getOrigin());
        }
        context.getMetadataCollector().addNamedQuery(queryBuilder.build());
    }

    public static void processNamedNativeQuery(HbmLocalMetadataBuildingContext context, JaxbHbmNamedNativeQueryType namedQueryBinding) {
        NamedQueryBinder.processNamedNativeQuery(context, namedQueryBinding, "");
    }

    public static void processNamedNativeQuery(HbmLocalMetadataBuildingContext context, JaxbHbmNamedNativeQueryType namedQueryBinding, String prefix) {
        if (namedQueryBinding.isCallable()) {
            DeprecationLogger.DEPRECATION_LOGGER.warn("Marking named native queries as callable is no longer supported; use `@jakarta.persistence.NamedStoredProcedureQuery` instead.  Ignoring.");
        }
        String registrationName = prefix + namedQueryBinding.getName();
        NamedNativeQueryDefinitionBuilder builder = new NamedNativeQueryDefinitionBuilder(registrationName).setComment(namedQueryBinding.getComment()).setCacheable(namedQueryBinding.isCacheable()).setCacheMode(namedQueryBinding.getCacheMode()).setCacheRegion(namedQueryBinding.getCacheRegion()).setTimeout(namedQueryBinding.getTimeout()).setReadOnly(namedQueryBinding.isReadOnly()).setFlushMode(namedQueryBinding.getFlushMode()).setFetchSize(namedQueryBinding.getFetchSize()).setResultSetMappingName(namedQueryBinding.getResultsetRef());
        ImplicitHbmResultSetMappingDescriptorBuilder implicitResultSetMappingBuilder = new ImplicitHbmResultSetMappingDescriptorBuilder(registrationName, context);
        boolean foundQuery = false;
        for (Serializable content : namedQueryBinding.getContent()) {
            boolean wasQuery = NamedQueryBinder.processNamedQueryContentItem(content, builder, implicitResultSetMappingBuilder, namedQueryBinding, context);
            if (!wasQuery) continue;
            foundQuery = true;
        }
        if (!foundQuery) {
            throw new MappingException(String.format("Named native query [%s] did not specify query string", namedQueryBinding.getName()), context.getOrigin());
        }
        if (implicitResultSetMappingBuilder.hasAnyReturns()) {
            if (StringHelper.isNotEmpty(namedQueryBinding.getResultsetRef())) {
                throw new MappingException(String.format("Named native query [%s] specified both a resultset-ref and an inline mapping of results", namedQueryBinding.getName()), context.getOrigin());
            }
            context.getMetadataCollector().addResultSetMapping(implicitResultSetMappingBuilder.build(context));
            builder.setResultSetMappingName(implicitResultSetMappingBuilder.getRegistrationName());
        }
        context.getMetadataCollector().addNamedNativeQuery(builder.build());
    }

    private static boolean processNamedQueryContentItem(Object content, NamedNativeQueryDefinitionBuilder queryBuilder, ImplicitHbmResultSetMappingDescriptorBuilder implicitResultSetMappingBuilder, JaxbHbmNamedNativeQueryType namedQueryBinding, HbmLocalMetadataBuildingContext context) {
        if (content instanceof String) {
            String contentString = StringHelper.nullIfEmpty(((String)content).trim());
            if (contentString != null) {
                queryBuilder.setSqlString((String)content);
                return true;
            }
            return false;
        }
        if (content instanceof JAXBElement) {
            return NamedQueryBinder.processNamedQueryContentItem(((JAXBElement)content).getValue(), queryBuilder, implicitResultSetMappingBuilder, namedQueryBinding, context);
        }
        if (content instanceof JaxbHbmQueryParamType) {
            JaxbHbmQueryParamType paramTypeBinding = (JaxbHbmQueryParamType)content;
            queryBuilder.addParameterTypeHint(paramTypeBinding.getName(), paramTypeBinding.getType());
        } else if (content instanceof JaxbHbmSynchronizeType) {
            JaxbHbmSynchronizeType synchronizedSpace = (JaxbHbmSynchronizeType)content;
            queryBuilder.addSynchronizedQuerySpace(synchronizedSpace.getTable());
        } else if (content instanceof JaxbHbmNativeQueryScalarReturnType) {
            implicitResultSetMappingBuilder.addReturn((JaxbHbmNativeQueryScalarReturnType)content);
        } else if (content instanceof JaxbHbmNativeQueryReturnType) {
            implicitResultSetMappingBuilder.addReturn((JaxbHbmNativeQueryReturnType)content);
        } else if (content instanceof JaxbHbmNativeQueryJoinReturnType) {
            implicitResultSetMappingBuilder.addReturn((JaxbHbmNativeQueryJoinReturnType)content);
        } else if (content instanceof JaxbHbmNativeQueryCollectionLoadReturnType) {
            implicitResultSetMappingBuilder.addReturn((JaxbHbmNativeQueryCollectionLoadReturnType)content);
        } else {
            throw new MappingException(String.format(Locale.ENGLISH, "Encountered unexpected content type [%s] for named native query [%s] : [%s]", content.getClass().getName(), namedQueryBinding.getName(), content.toString()), context.getOrigin());
        }
        return false;
    }
}

