/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedStoredProcedureQuery;
import jakarta.persistence.SqlResultSetMapping;
import jakarta.persistence.SqlResultSetMappings;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.boot.internal.NamedHqlQueryDefinitionImpl;
import org.hibernate.boot.internal.NamedProcedureCallDefinitionImpl;
import org.hibernate.boot.query.NamedHqlQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinition;
import org.hibernate.boot.query.NamedNativeQueryDefinitionBuilder;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.annotations.QueryHintDefinition;
import org.hibernate.cfg.annotations.ResultsetMappingSecondPass;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public abstract class QueryBinder {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)QueryBinder.class.getName());

    public static void bindQuery(jakarta.persistence.NamedQuery queryAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String queryName = queryAnn.name();
        String queryString = queryAnn.query();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", queryName, queryString);
        }
        QueryHintDefinition hints = new QueryHintDefinition(queryName, queryAnn.hints());
        NamedHqlQueryDefinitionImpl queryMapping = ((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(queryName).setHqlString(queryString).setCacheable(hints.getCacheability())).setCacheMode(hints.getCacheMode())).setCacheRegion(hints.getString("org.hibernate.cacheRegion"))).setTimeout(hints.getTimeout())).setFetchSize(hints.getInteger("org.hibernate.fetchSize"))).setFlushMode(hints.getFlushMode())).setReadOnly(hints.getBoolean("org.hibernate.readOnly"))).setLockOptions(hints.determineLockOptions(queryAnn))).setComment(hints.getString("org.hibernate.comment"))).build();
        if (isDefault) {
            context.getMetadataCollector().addDefaultQuery(queryMapping);
        } else {
            context.getMetadataCollector().addNamedQuery(queryMapping);
        }
    }

    public static void bindNativeQuery(jakarta.persistence.NamedNativeQuery queryAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queryAnn == null) {
            return;
        }
        if (BinderHelper.isEmptyAnnotationValue(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String registrationName = queryAnn.name();
        String queryString = queryAnn.query();
        QueryHintDefinition hints = new QueryHintDefinition(registrationName, queryAnn.hints());
        String resultSetMappingName = queryAnn.resultSetMapping();
        String resultSetMappingClassName = Void.TYPE.equals(queryAnn.resultClass()) ? null : queryAnn.resultClass().getName();
        NamedNativeQueryDefinitionBuilder builder = (NamedNativeQueryDefinitionBuilder)new NamedNativeQueryDefinitionBuilder(registrationName).setSqlString(queryString).setResultSetMappingName(resultSetMappingName).setResultSetMappingClassName(resultSetMappingClassName).setQuerySpaces(null).setCacheable(hints.getCacheability()).setCacheMode(hints.getCacheMode()).setCacheRegion(hints.getString("org.hibernate.cacheRegion")).setTimeout(hints.getTimeout()).setFetchSize(hints.getInteger("org.hibernate.fetchSize")).setFlushMode(hints.getFlushMode()).setReadOnly(hints.getBoolean("org.hibernate.readOnly")).setComment(hints.getString("org.hibernate.comment")).addHints(hints.getHintsMap());
        NamedNativeQueryDefinition queryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedNativeQuery(queryDefinition);
        } else {
            context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
        }
    }

    public static void bindNativeQuery(NamedNativeQuery queryAnn, MetadataBuildingContext context) {
        if (queryAnn == null) {
            return;
        }
        String registrationName = queryAnn.name();
        if (BinderHelper.isEmptyAnnotationValue(registrationName)) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String resultSetMappingName = queryAnn.resultSetMapping();
        String resultSetMappingClassName = Void.TYPE.equals(queryAnn.resultClass()) ? null : queryAnn.resultClass().getName();
        NamedNativeQueryDefinitionBuilder builder = new NamedNativeQueryDefinitionBuilder(registrationName).setSqlString(queryAnn.query()).setResultSetMappingName(resultSetMappingName).setResultSetMappingClassName(resultSetMappingClassName).setQuerySpaces(null).setCacheable(queryAnn.cacheable()).setCacheRegion(BinderHelper.getAnnotationValueStringOrNull(queryAnn.cacheRegion())).setCacheMode(QueryBinder.getCacheMode(queryAnn.cacheMode())).setTimeout(queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout())).setFetchSize(queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize())).setFlushMode(QueryBinder.getFlushMode(queryAnn.flushMode())).setReadOnly(queryAnn.readOnly()).setComment(BinderHelper.getAnnotationValueStringOrNull(queryAnn.comment()));
        NamedNativeQueryDefinition queryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named native query: %s => %s", queryDefinition.getRegistrationName(), queryDefinition.getSqlQueryString());
        }
        context.getMetadataCollector().addNamedNativeQuery(queryDefinition);
    }

    public static void bindQueries(NamedQueries queriesAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (jakarta.persistence.NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, context, isDefault);
        }
    }

    public static void bindNativeQueries(jakarta.persistence.NamedNativeQueries queriesAnn, MetadataBuildingContext context, boolean isDefault) {
        if (queriesAnn == null) {
            return;
        }
        for (jakarta.persistence.NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, context, isDefault);
        }
    }

    public static void bindNativeQueries(NamedNativeQueries queriesAnn, MetadataBuildingContext context) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, context);
        }
    }

    public static void bindQuery(NamedQuery queryAnn, MetadataBuildingContext context) {
        if (queryAnn == null) {
            return;
        }
        String registrationName = queryAnn.name();
        if (BinderHelper.isEmptyAnnotationValue(registrationName)) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        NamedHqlQueryDefinition.Builder builder = (NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)((NamedHqlQueryDefinition.Builder)new NamedHqlQueryDefinition.Builder(registrationName).setHqlString(queryAnn.query()).setCacheable(queryAnn.cacheable())).setCacheRegion(BinderHelper.getAnnotationValueStringOrNull(queryAnn.cacheRegion()))).setCacheMode(QueryBinder.getCacheMode(queryAnn.cacheMode()))).setTimeout(queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()))).setFetchSize(queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()))).setFlushMode(QueryBinder.getFlushMode(queryAnn.flushMode()))).setReadOnly(queryAnn.readOnly())).setComment(BinderHelper.isEmptyAnnotationValue(queryAnn.comment()) ? null : queryAnn.comment());
        NamedHqlQueryDefinitionImpl hqlQueryDefinition = builder.build();
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Binding named query: %s => %s", hqlQueryDefinition.getRegistrationName(), hqlQueryDefinition.getHqlString());
        }
        context.getMetadataCollector().addNamedQuery(hqlQueryDefinition);
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        FlushMode flushMode;
        switch (flushModeType) {
            case ALWAYS: {
                flushMode = FlushMode.ALWAYS;
                break;
            }
            case AUTO: {
                flushMode = FlushMode.AUTO;
                break;
            }
            case COMMIT: {
                flushMode = FlushMode.COMMIT;
                break;
            }
            case MANUAL: {
                flushMode = FlushMode.MANUAL;
                break;
            }
            case PERSISTENCE_CONTEXT: {
                flushMode = null;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown flushModeType: " + (Object)((Object)flushModeType));
            }
        }
        return flushMode;
    }

    private static CacheMode getCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + (Object)((Object)cacheModeType));
    }

    public static void bindQueries(org.hibernate.annotations.NamedQueries queriesAnn, MetadataBuildingContext context) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, context);
        }
    }

    public static void bindNamedStoredProcedureQuery(NamedStoredProcedureQuery annotation, MetadataBuildingContext context, boolean isDefault) {
        if (annotation == null) {
            return;
        }
        String registrationName = annotation.name();
        if (BinderHelper.isEmptyAnnotationValue(registrationName)) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        NamedProcedureCallDefinitionImpl def = new NamedProcedureCallDefinitionImpl(annotation);
        if (isDefault) {
            context.getMetadataCollector().addDefaultNamedProcedureCall(def);
        } else {
            context.getMetadataCollector().addNamedProcedureCallDefinition(def);
        }
        LOG.debugf("Bound named stored procedure query : %s => %s", def.getRegistrationName(), def.getProcedureName());
    }

    public static void bindSqlResultSetMappings(SqlResultSetMappings ann, MetadataBuildingContext context, boolean isDefault) {
        if (ann == null) {
            return;
        }
        for (SqlResultSetMapping rs : ann.value()) {
            context.getMetadataCollector().addSecondPass(new ResultsetMappingSecondPass(rs, context, true));
        }
    }

    public static void bindSqlResultSetMapping(SqlResultSetMapping ann, MetadataBuildingContext context, boolean isDefault) {
        context.getMetadataCollector().addSecondPass(new ResultsetMappingSecondPass(ann, context, isDefault));
    }
}

