/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import java.util.Arrays;
import java.util.List;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampdiffFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;

    public TimestampdiffFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super("timestampdiff", StandardArgumentsValidators.exactly(3), StandardFunctionReturnTypeResolvers.invariant(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.LONG)));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<SqlAstNode> arguments, SqlAstTranslator<?> walker) {
        DurationUnit field = (DurationUnit)arguments.get(0);
        Expression from = (Expression)arguments.get(1);
        Expression to = (Expression)arguments.get(2);
        String pattern = this.dialect.timestampdiffPattern(field.getUnit(), TypeConfiguration.getSqlTemporalType(from.getExpressionType()), TypeConfiguration.getSqlTemporalType(to.getExpressionType()));
        new PatternRenderer(pattern).render(sqlAppender, arguments, walker);
    }

    public SelfRenderingFunctionSqlAstExpression expression(AllowableFunctionReturnType<?> impliedResultType, SqlAstNode ... sqlAstArguments) {
        DurationUnit field = (DurationUnit)sqlAstArguments[0];
        return new SelfRenderingFunctionSqlAstExpression(this.getName(), this::render, Arrays.asList(sqlAstArguments), impliedResultType, field.getExpressionType());
    }

    @Override
    public String getArgumentListSignature() {
        return "(field, start, end)";
    }
}

