/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc.batch.internal;

import java.util.Map;
import org.hibernate.engine.jdbc.batch.internal.BatchBuilderMXBean;
import org.hibernate.engine.jdbc.batch.internal.BatchingBatch;
import org.hibernate.engine.jdbc.batch.internal.NonBatchingBatch;
import org.hibernate.engine.jdbc.batch.spi.Batch;
import org.hibernate.engine.jdbc.batch.spi.BatchBuilder;
import org.hibernate.engine.jdbc.batch.spi.BatchKey;
import org.hibernate.engine.jdbc.spi.JdbcCoordinator;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.service.spi.Configurable;

public class BatchBuilderImpl
implements BatchBuilder,
Configurable,
BatchBuilderMXBean {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(BatchBuilderImpl.class);
    private int jdbcBatchSize;

    public BatchBuilderImpl() {
    }

    public BatchBuilderImpl(int jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
    }

    @Override
    public void configure(Map configurationValues) {
        this.jdbcBatchSize = ConfigurationHelper.getInt("hibernate.jdbc.batch_size", configurationValues, this.jdbcBatchSize);
    }

    @Override
    public int getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    @Override
    public void setJdbcBatchSize(int jdbcBatchSize) {
        this.jdbcBatchSize = jdbcBatchSize;
    }

    @Override
    public Batch buildBatch(BatchKey key, JdbcCoordinator jdbcCoordinator) {
        Integer sessionJdbcBatchSize = jdbcCoordinator.getJdbcSessionOwner().getJdbcBatchSize();
        int jdbcBatchSizeToUse = sessionJdbcBatchSize == null ? this.jdbcBatchSize : sessionJdbcBatchSize;
        return jdbcBatchSizeToUse > 1 ? new BatchingBatch(key, jdbcCoordinator, jdbcBatchSizeToUse) : new NonBatchingBatch(key, jdbcCoordinator);
    }
}

