/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.internal;

import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.CollectionClassification;
import org.hibernate.metamodel.ValueClassification;
import org.hibernate.metamodel.internal.AttributeFactory;
import org.hibernate.metamodel.internal.AttributeMetadata;
import org.hibernate.metamodel.internal.BaseAttributeMetadata;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.internal.PluralAttributeMetadata;
import org.hibernate.metamodel.internal.ValueContext;
import org.hibernate.metamodel.model.domain.ManagedDomainType;

class PluralAttributeMetadataImpl<X, Y, E>
extends BaseAttributeMetadata<X, Y>
implements PluralAttributeMetadata<X, Y, E> {
    private final CollectionClassification collectionClassification;
    private final AttributeClassification elementClassification;
    private final AttributeClassification listIndexOrMapKeyClassification;
    private final Class elementJavaType;
    private final Class keyJavaType;
    private final ValueContext elementValueContext;
    private final ValueContext keyValueContext;

    PluralAttributeMetadataImpl(Property propertyMapping, ManagedDomainType<X> ownerType, Member member, AttributeClassification attributeClassification, AttributeClassification elementClassification, AttributeClassification listIndexOrMapKeyClassification, MetadataContext metadataContext) {
        super(propertyMapping, ownerType, member, attributeClassification, metadataContext);
        this.collectionClassification = PluralAttributeMetadataImpl.determineCollectionType(this.getJavaType(), propertyMapping);
        this.elementClassification = elementClassification;
        this.listIndexOrMapKeyClassification = listIndexOrMapKeyClassification;
        ParameterizedType signatureType = AttributeFactory.getSignatureType(member);
        switch (this.collectionClassification) {
            case MAP: 
            case SORTED_MAP: 
            case ORDERED_MAP: {
                this.keyJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[0]) : Object.class;
                this.elementJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[1]) : Object.class;
                break;
            }
            case ARRAY: 
            case LIST: {
                this.keyJavaType = Integer.class;
                this.elementJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[0]) : Object.class;
                break;
            }
            default: {
                this.elementJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[0]) : Object.class;
                this.keyJavaType = null;
            }
        }
        this.elementValueContext = new ValueContext(){

            @Override
            public Value getHibernateValue() {
                return ((org.hibernate.mapping.Collection)PluralAttributeMetadataImpl.this.getPropertyMapping().getValue()).getElement();
            }

            @Override
            public Class getJpaBindableType() {
                return PluralAttributeMetadataImpl.this.elementJavaType;
            }

            @Override
            public ValueClassification getValueClassification() {
                switch (PluralAttributeMetadataImpl.this.elementClassification) {
                    case EMBEDDED: {
                        return ValueClassification.EMBEDDABLE;
                    }
                    case BASIC: {
                        return ValueClassification.BASIC;
                    }
                }
                return ValueClassification.ENTITY;
            }

            @Override
            public AttributeMetadata getAttributeMetadata() {
                return PluralAttributeMetadataImpl.this;
            }
        };
        this.keyValueContext = this.listIndexOrMapKeyClassification != null ? new ValueContext(){

            @Override
            public Value getHibernateValue() {
                return ((Map)PluralAttributeMetadataImpl.this.getPropertyMapping().getValue()).getIndex();
            }

            @Override
            public Class getJpaBindableType() {
                return PluralAttributeMetadataImpl.this.keyJavaType;
            }

            @Override
            public ValueClassification getValueClassification() {
                switch (PluralAttributeMetadataImpl.this.listIndexOrMapKeyClassification) {
                    case EMBEDDED: {
                        return ValueClassification.EMBEDDABLE;
                    }
                    case BASIC: {
                        return ValueClassification.BASIC;
                    }
                }
                return ValueClassification.ENTITY;
            }

            @Override
            public AttributeMetadata getAttributeMetadata() {
                return PluralAttributeMetadataImpl.this;
            }
        } : null;
    }

    private Class<?> getClassFromGenericArgument(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof TypeVariable) {
            Type upperBound = ((TypeVariable)type).getBounds()[0];
            return this.getClassFromGenericArgument(upperBound);
        }
        if (type instanceof ParameterizedType) {
            Type rawType = ((ParameterizedType)type).getRawType();
            return this.getClassFromGenericArgument(rawType);
        }
        if (type instanceof WildcardType) {
            Type upperBound = ((WildcardType)type).getUpperBounds()[0];
            return this.getClassFromGenericArgument(upperBound);
        }
        throw new AssertionFailure("Fail to process type argument in a generic declaration. Member : " + this.getMemberDescription() + " Type: " + type.getClass());
    }

    public static CollectionClassification determineCollectionType(Class javaType, Property property) {
        org.hibernate.mapping.Collection collection = (org.hibernate.mapping.Collection)property.getValue();
        if (List.class.isAssignableFrom(javaType)) {
            return CollectionClassification.LIST;
        }
        if (Set.class.isAssignableFrom(javaType)) {
            if (collection.isSorted()) {
                return CollectionClassification.SORTED_SET;
            }
            if (collection.hasOrder()) {
                return CollectionClassification.ORDERED_SET;
            }
            return CollectionClassification.SET;
        }
        if (java.util.Map.class.isAssignableFrom(javaType)) {
            if (collection.isSorted()) {
                return CollectionClassification.SORTED_MAP;
            }
            if (collection.hasOrder()) {
                return CollectionClassification.ORDERED_MAP;
            }
            return CollectionClassification.MAP;
        }
        if (Collection.class.isAssignableFrom(javaType)) {
            if (collection.isIdentified()) {
                return CollectionClassification.IDBAG;
            }
            return CollectionClassification.BAG;
        }
        if (javaType.isArray()) {
            return CollectionClassification.ARRAY;
        }
        throw new IllegalArgumentException("Expecting collection type [" + javaType.getName() + "]");
    }

    @Override
    public ValueContext getElementValueContext() {
        return this.elementValueContext;
    }

    @Override
    public CollectionClassification getCollectionClassification() {
        return this.collectionClassification;
    }

    @Override
    public ValueContext getMapKeyValueContext() {
        return this.keyValueContext;
    }
}

