/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hibernate.MappingException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SharedSessionContract;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.config.spi.ConfigurationService;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.mapping.Any;
import org.hibernate.mapping.BasicValue;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Table;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.MappingModelCreationLogger;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.SelectableMappings;
import org.hibernate.metamodel.mapping.StateArrayContributorMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadata;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractSingularAttributeMapping;
import org.hibernate.metamodel.mapping.internal.BasicAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedAssociationAttributeMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.SelectableMappingsImpl;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.metamodel.spi.EmbeddableRepresentationStrategy;
import org.hibernate.metamodel.spi.RuntimeModelCreationContext;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.embeddable.internal.EmbeddableResultImpl;
import org.hibernate.type.AnyType;
import org.hibernate.type.BasicType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableMappingType
implements ManagedMappingType,
SelectableMappings {
    private final JavaType<?> embeddableJtd;
    private final EmbeddableRepresentationStrategy representationStrategy;
    private final SessionFactoryImplementor sessionFactory;
    private final List<AttributeMapping> attributeMappings = new ArrayList<AttributeMapping>();
    private SelectableMappings selectableMappings;
    private final EmbeddableValuedModelPart valueMapping;
    private NavigableRole embeddedRole;
    private final boolean createEmptyCompositesEnabled;

    public static EmbeddableMappingType from(Component bootDescriptor, CompositeType compositeType, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        return EmbeddableMappingType.from(bootDescriptor, compositeType, null, null, embeddedPartBuilder, creationProcess);
    }

    public static EmbeddableMappingType from(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, MappingModelCreationProcess creationProcess) {
        RuntimeModelCreationContext creationContext = creationProcess.getCreationContext();
        EmbeddableRepresentationStrategy representationStrategy = creationContext.getBootstrapContext().getRepresentationStrategySelector().resolveStrategy(bootDescriptor, creationContext);
        EmbeddableMappingType mappingType = new EmbeddableMappingType(bootDescriptor, representationStrategy, embeddedPartBuilder, creationContext.getSessionFactory());
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + mappingType.getNavigableRole().getFullPath() + ")#finishInitialization", () -> {
            try {
                boolean finished = mappingType.finishInitialization(bootDescriptor, compositeType, rootTableExpression, rootTableKeyColumnNames, creationProcess);
                if (finished) {
                    return finished;
                }
            }
            catch (Exception e) {
                MappingModelCreationLogger.LOGGER.debugf(e, "(DEBUG) Error finalizing EmbeddableMappingType(%s)", mappingType.embeddedRole);
            }
            MappingModelCreationLogger.LOGGER.debugf("EmbeddableMappingType(%s) finalization was not able to complete successfully", mappingType.embeddedRole);
            return false;
        });
        return mappingType;
    }

    private EmbeddableMappingType(Component bootDescriptor, EmbeddableRepresentationStrategy representationStrategy, Function<EmbeddableMappingType, EmbeddableValuedModelPart> embeddedPartBuilder, SessionFactoryImplementor sessionFactory) {
        this.embeddableJtd = representationStrategy.getMappedJavaTypeDescriptor();
        this.representationStrategy = representationStrategy;
        this.sessionFactory = sessionFactory;
        this.valueMapping = embeddedPartBuilder.apply(this);
        ConfigurationService cs = sessionFactory.getServiceRegistry().getService(ConfigurationService.class);
        this.createEmptyCompositesEnabled = ConfigurationHelper.getBoolean("hibernate.create_empty_composites.enabled", cs.getSettings(), false);
    }

    private EmbeddableMappingType(EmbeddableValuedModelPart valueMapping, SelectableMappings selectableMappings, EmbeddableMappingType inverseMappingType, MappingModelCreationProcess creationProcess) {
        this.embeddableJtd = inverseMappingType.embeddableJtd;
        this.representationStrategy = inverseMappingType.representationStrategy;
        this.sessionFactory = inverseMappingType.sessionFactory;
        this.valueMapping = valueMapping;
        this.createEmptyCompositesEnabled = inverseMappingType.isCreateEmptyCompositesEnabled();
        this.selectableMappings = selectableMappings;
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + inverseMappingType.getNavigableRole().getFullPath() + ".{inverse})#finishInitialization", () -> {
            if (inverseMappingType.attributeMappings.isEmpty()) {
                return false;
            }
            this.attributeMappings.clear();
            int currentIndex = 0;
            for (AttributeMapping attributeMapping : inverseMappingType.attributeMappings) {
                AbstractSingularAttributeMapping original;
                if (attributeMapping instanceof BasicAttributeMapping) {
                    original = (BasicAttributeMapping)attributeMapping;
                    SelectableMapping selectableMapping = selectableMappings.getSelectable(currentIndex);
                    attributeMapping = BasicAttributeMapping.withSelectableMapping((BasicValuedModelPart)((Object)original), original.getPropertyAccess(), original.getValueGeneration(), selectableMapping);
                    ++currentIndex;
                } else if (attributeMapping instanceof ToOneAttributeMapping) {
                    original = (ToOneAttributeMapping)attributeMapping;
                    ToOneAttributeMapping toOne = ((ToOneAttributeMapping)original).copy();
                    int offset = currentIndex;
                    toOne.setIdentifyingColumnsTableExpression(selectableMappings.getSelectable(offset).getContainingTableExpression());
                    toOne.setForeignKeyDescriptor(((ToOneAttributeMapping)original).getForeignKeyDescriptor().withKeySelectionMapping(index -> selectableMappings.getSelectable(offset + index), creationProcess));
                    attributeMapping = toOne;
                    currentIndex += attributeMapping.getJdbcTypeCount();
                } else {
                    throw new UnsupportedOperationException("Only basic and to-one attributes are supported in composite fks");
                }
                this.attributeMappings.add(attributeMapping);
            }
            return true;
        });
    }

    public EmbeddableMappingType createInverseMappingType(EmbeddableValuedModelPart valueMapping, SelectableMappings selectableMappings, MappingModelCreationProcess creationProcess) {
        return new EmbeddableMappingType(valueMapping, selectableMappings, this, creationProcess);
    }

    private boolean finishInitialization(Component bootDescriptor, CompositeType compositeType, String rootTableExpression, String[] rootTableKeyColumnNames, final MappingModelCreationProcess creationProcess) {
        SessionFactoryImplementor sessionFactory = creationProcess.getCreationContext().getSessionFactory();
        TypeConfiguration typeConfiguration = sessionFactory.getTypeConfiguration();
        JdbcServices jdbcServices = sessionFactory.getJdbcServices();
        JdbcEnvironment jdbcEnvironment = jdbcServices.getJdbcEnvironment();
        Dialect dialect = jdbcEnvironment.getDialect();
        String baseTableExpression = this.valueMapping.getContainingTableExpression();
        Type[] subtypes = compositeType.getSubtypes();
        int attributeIndex = 0;
        int columnPosition = 0;
        this.attributeMappings.clear();
        Iterator<Property> propertyIterator = bootDescriptor.getPropertyIterator();
        while (propertyIterator.hasNext()) {
            EntityPersister entityPersister;
            StateArrayContributorMapping attributeMapping;
            Property bootPropertyDescriptor = propertyIterator.next();
            Type subtype = subtypes[attributeIndex];
            if (subtype instanceof BasicType) {
                String containingTableExpression;
                String columnExpression;
                BasicValue basicValue = (BasicValue)bootPropertyDescriptor.getValue();
                Selectable selectable = basicValue.getColumn();
                if (rootTableKeyColumnNames == null) {
                    columnExpression = selectable.isFormula() ? selectable.getTemplate(dialect, creationProcess.getSqmFunctionRegistry()) : selectable.getText(dialect);
                    containingTableExpression = selectable instanceof Column ? EmbeddableMappingType.getTableIdentifierExpression(((Column)selectable).getValue().getTable(), jdbcEnvironment) : baseTableExpression;
                } else {
                    containingTableExpression = rootTableExpression;
                    columnExpression = rootTableKeyColumnNames[columnPosition];
                }
                attributeMapping = MappingModelCreationHelper.buildBasicAttributeMapping(bootPropertyDescriptor.getName(), this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), attributeIndex, bootPropertyDescriptor, this, (BasicType)subtype, containingTableExpression, columnExpression, selectable.isFormula(), selectable.getCustomReadExpression(), selectable.getCustomWriteExpression(), this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                ++columnPosition;
            } else if (subtype instanceof AnyType) {
                Any bootValueMapping = (Any)bootPropertyDescriptor.getValue();
                final AnyType anyType = (AnyType)subtype;
                final PropertyAccess propertyAccess = this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor);
                final boolean nullable = bootValueMapping.isNullable();
                final boolean insertable = bootPropertyDescriptor.isInsertable();
                final boolean updateable = bootPropertyDescriptor.isUpdateable();
                final boolean includeInOptimisticLocking = bootPropertyDescriptor.isOptimisticLocked();
                final CascadeStyle cascadeStyle = compositeType.getCascadeStyle(attributeIndex);
                final MutabilityPlan mutabilityPlan = updateable ? new MutabilityPlan(){

                    @Override
                    public boolean isMutable() {
                        return true;
                    }

                    public Object deepCopy(Object value) {
                        if (value == null) {
                            return null;
                        }
                        return anyType.deepCopy(value, creationProcess.getCreationContext().getSessionFactory());
                    }

                    public Serializable disassemble(Object value, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }

                    public Object assemble(Serializable cached, SharedSessionContract session) {
                        throw new NotYetImplementedFor6Exception(this.getClass());
                    }
                } : ImmutableMutabilityPlan.INSTANCE;
                StateArrayContributorMetadataAccess attributeMetadataAccess = entityMappingType -> new StateArrayContributorMetadata(){

                    @Override
                    public PropertyAccess getPropertyAccess() {
                        return propertyAccess;
                    }

                    @Override
                    public MutabilityPlan getMutabilityPlan() {
                        return mutabilityPlan;
                    }

                    @Override
                    public boolean isNullable() {
                        return nullable;
                    }

                    @Override
                    public boolean isInsertable() {
                        return insertable;
                    }

                    @Override
                    public boolean isUpdatable() {
                        return updateable;
                    }

                    @Override
                    public boolean isIncludedInDirtyChecking() {
                        return updateable;
                    }

                    @Override
                    public boolean isIncludedInOptimisticLocking() {
                        return includeInOptimisticLocking;
                    }

                    @Override
                    public CascadeStyle getCascadeStyle() {
                        return cascadeStyle;
                    }
                };
                attributeMapping = new DiscriminatedAssociationAttributeMapping(this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), typeConfiguration.getJavaTypeDescriptorRegistry().getDescriptor((java.lang.reflect.Type)((Object)Object.class)), this, attributeIndex, attributeMetadataAccess, bootPropertyDescriptor.isLazy() ? FetchTiming.DELAYED : FetchTiming.IMMEDIATE, propertyAccess, bootPropertyDescriptor, anyType, bootValueMapping, creationProcess);
            } else if (subtype instanceof CompositeType) {
                String[] subRootTableKeyColumnNames;
                String subTableExpression;
                CompositeType subCompositeType = (CompositeType)subtype;
                int columnSpan = subCompositeType.getColumnSpan(sessionFactory);
                if (rootTableKeyColumnNames == null) {
                    subTableExpression = baseTableExpression;
                    subRootTableKeyColumnNames = null;
                } else {
                    subTableExpression = rootTableExpression;
                    subRootTableKeyColumnNames = new String[columnSpan];
                    System.arraycopy(rootTableKeyColumnNames, columnPosition, subRootTableKeyColumnNames, 0, columnSpan);
                }
                attributeMapping = MappingModelCreationHelper.buildEmbeddedAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, this, subCompositeType, subTableExpression, subRootTableKeyColumnNames, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += columnSpan;
            } else if (subtype instanceof CollectionType) {
                entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildPluralAttributeMapping(bootPropertyDescriptor.getName(), attributeIndex, bootPropertyDescriptor, entityPersister, this.representationStrategy.resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), compositeType.getFetchMode(attributeIndex), creationProcess);
            } else if (subtype instanceof EntityType) {
                entityPersister = creationProcess.getEntityPersister(bootDescriptor.getOwner().getEntityName());
                attributeMapping = MappingModelCreationHelper.buildSingularAssociationAttributeMapping(bootPropertyDescriptor.getName(), this.valueMapping.getNavigableRole().append(bootPropertyDescriptor.getName()), attributeIndex, bootPropertyDescriptor, entityPersister, entityPersister, (EntityType)subtype, this.getRepresentationStrategy().resolvePropertyAccess(bootPropertyDescriptor), compositeType.getCascadeStyle(attributeIndex), creationProcess);
                columnPosition += bootPropertyDescriptor.getColumnSpan();
            } else {
                throw new MappingException(String.format(Locale.ROOT, "Unable to determine attribute nature : %s#%s", bootDescriptor.getOwner().getEntityName(), bootPropertyDescriptor.getName()));
            }
            this.addAttribute(attributeMapping);
            ++attributeIndex;
        }
        creationProcess.registerInitializationCallback("EmbeddableMappingType(" + this.embeddedRole + ")#initColumnMappings", this::initColumnMappings);
        return true;
    }

    private static String getTableIdentifierExpression(Table table, JdbcEnvironment jdbcEnvironment) {
        return jdbcEnvironment.getQualifiedObjectNameFormatter().format(table.getQualifiedTableName(), jdbcEnvironment.getDialect());
    }

    private boolean initColumnMappings() {
        this.selectableMappings = SelectableMappingsImpl.from(this);
        return true;
    }

    private void addAttribute(AttributeMapping attributeMapping) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping previous = this.attributeMappings.get(i);
            if (!attributeMapping.getAttributeName().equals(previous.getAttributeName())) continue;
            this.attributeMappings.set(i, attributeMapping);
            return;
        }
        this.attributeMappings.add(attributeMapping);
    }

    public EmbeddableValuedModelPart getEmbeddedValueMapping() {
        return this.valueMapping;
    }

    public JavaType getMappedJavaTypeDescriptor() {
        return this.embeddableJtd;
    }

    public EmbeddableRepresentationStrategy getRepresentationStrategy() {
        return this.representationStrategy;
    }

    @Override
    public String getPartName() {
        return this.getEmbeddedValueMapping().getPartName();
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.valueMapping.getNavigableRole();
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        return new EmbeddableResultImpl(navigablePath, this.valueMapping, resultVariable, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.visitAttributeMappings(attributeMapping -> attributeMapping.applySqlSelections(navigablePath, tableGroup, creationState));
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.visitAttributeMappings(attributeMapping -> ManagedMappingType.super.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer));
    }

    @Override
    public int getNumberOfFetchables() {
        return this.attributeMappings.size();
    }

    @Override
    public void visitFetchables(Consumer<Fetchable> fetchableConsumer, EntityMappingType treatTargetType) {
        this.visitAttributeMappings(attributeMapping -> fetchableConsumer.accept((Fetchable)attributeMapping));
    }

    @Override
    public SelectableMapping getSelectable(int columnIndex) {
        return this.selectableMappings.getSelectable(columnIndex);
    }

    @Override
    public int getJdbcTypeCount() {
        return this.selectableMappings.getJdbcTypeCount();
    }

    @Override
    public List<JdbcMapping> getJdbcMappings() {
        return this.selectableMappings.getJdbcMappings();
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        return this.selectableMappings.forEachSelectable(offset, (index, selectable) -> action.accept(index, selectable.getJdbcMapping()));
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        if (domainValue instanceof Object[]) {
            Object[] values = (Object[])domainValue;
            assert (values.length == this.attributeMappings.size());
            for (int i = 0; i < this.attributeMappings.size(); ++i) {
                AttributeMapping attributeMapping2 = this.attributeMappings.get(i);
                Object attributeValue = values[i];
                attributeMapping2.breakDownJdbcValues(attributeValue, valueConsumer, session);
            }
        } else {
            this.attributeMappings.forEach(attributeMapping -> {
                Object attributeValue = attributeMapping.getPropertyAccess().getGetter().get(domainValue);
                attributeMapping.breakDownJdbcValues(attributeValue, valueConsumer, session);
            });
        }
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        List<AttributeMapping> attributeMappings = this.getAttributeMappings();
        Object[] result = new Object[attributeMappings.size()];
        for (int i = 0; i < attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = attributeMappings.get(i);
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            result[i] = attributeMapping.disassemble(o, session);
        }
        return result;
    }

    @Override
    public int forEachJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer consumer, SharedSessionContractImplementor session) {
        int span = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attributeMapping = this.attributeMappings.get(i);
            if (attributeMapping instanceof PluralAttributeMapping) continue;
            Object o = attributeMapping.getPropertyAccess().getGetter().get(value);
            span += attributeMapping.forEachJdbcValue(o, clause, span + offset, consumer, session);
        }
        return span;
    }

    @Override
    public int forEachDisassembledJdbcValue(Object value, Clause clause, int offset, Bindable.JdbcValuesConsumer valuesConsumer, SharedSessionContractImplementor session) {
        Object[] values = (Object[])value;
        int span = 0;
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping mapping = this.attributeMappings.get(i);
            span += mapping.forEachDisassembledJdbcValue(values[i], clause, span + offset, valuesConsumer, session);
        }
        return span;
    }

    @Override
    public int forEachSelectable(SelectableConsumer consumer) {
        return this.selectableMappings.forEachSelectable(0, consumer);
    }

    @Override
    public int forEachSelectable(int offset, SelectableConsumer consumer) {
        return this.selectableMappings.forEachSelectable(offset, consumer);
    }

    @Override
    public EntityMappingType findContainingEntityMapping() {
        return this.valueMapping.findContainingEntityMapping();
    }

    @Override
    public int getNumberOfAttributeMappings() {
        return this.attributeMappings.size();
    }

    @Override
    public AttributeMapping findAttributeMapping(String name) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            AttributeMapping attr = this.attributeMappings.get(i);
            if (!name.equals(attr.getAttributeName())) continue;
            return attr;
        }
        return null;
    }

    @Override
    public List<AttributeMapping> getAttributeMappings() {
        return this.attributeMappings;
    }

    @Override
    public void forEachAttributeMapping(IndexedConsumer<AttributeMapping> consumer) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            consumer.accept(i, this.attributeMappings.get(i));
        }
    }

    @Override
    public void visitAttributeMappings(Consumer<AttributeMapping> action) {
        this.attributeMappings.forEach(action);
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        return this.findAttributeMapping(name);
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        this.visitAttributeMappings(consumer::accept);
    }

    public void setPropertyValues(Object compositeInstance, Object[] resolvedValues) {
        for (int i = 0; i < this.attributeMappings.size(); ++i) {
            this.attributeMappings.get(i).getAttributeMetadataAccess().resolveAttributeMetadata(null).getPropertyAccess().getSetter().set(compositeInstance, resolvedValues[i], this.sessionFactory);
        }
    }

    public boolean isCreateEmptyCompositesEnabled() {
        return this.createEmptyCompositesEnabled;
    }
}

