/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.AbstractDiscriminatorMapping;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;

public class CaseStatementDiscriminatorMappingImpl
extends AbstractDiscriminatorMapping {
    private final LinkedHashMap<String, TableDiscriminatorDetails> tableDiscriminatorDetailsMap = new LinkedHashMap();

    public CaseStatementDiscriminatorMappingImpl(JoinedSubclassEntityPersister entityDescriptor, String[] tableNames, int[] notNullColumnTableNumbers, String[] notNullColumnNames, String[] discriminatorValues, Map<String, String> subEntityNameByTableName, DiscriminatorType<?> incomingDiscriminatorType, MappingModelCreationProcess creationProcess) {
        super(incomingDiscriminatorType.getUnderlyingType().getJdbcMapping(), entityDescriptor, incomingDiscriminatorType, creationProcess);
        for (int i = 0; i < discriminatorValues.length; ++i) {
            String tableName = tableNames[notNullColumnTableNumbers[i]];
            String subEntityName = subEntityNameByTableName.get(tableName);
            String oneSubEntityColumn = notNullColumnNames[i];
            String rawDiscriminatorValue = discriminatorValues[i];
            Object discriminatorValue = this.getUnderlyingJdbcMappingType().getJavaTypeDescriptor().wrap(rawDiscriminatorValue, null);
            this.tableDiscriminatorDetailsMap.put(tableName, new TableDiscriminatorDetails(tableName, oneSubEntityColumn, discriminatorValue, subEntityName));
        }
    }

    @Override
    public Expression resolveSqlExpression(NavigablePath navigablePath, JdbcMapping jdbcMappingToUse, TableGroup tableGroup, SqlAstCreationState creationState) {
        SqlExpressionResolver expressionResolver = creationState.getSqlExpressionResolver();
        return expressionResolver.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getPrimaryTableReference(), this.getSelectionExpression()), sqlAstProcessingState -> this.createCaseSearchedExpression(tableGroup));
    }

    private CaseSearchedExpression createCaseSearchedExpression(TableGroup entityTableGroup) {
        CaseSearchedExpression caseSearchedExpression = new CaseSearchedExpression(this);
        this.tableDiscriminatorDetailsMap.forEach((tableName, tableDiscriminatorDetails) -> {
            TableReference tableReference = entityTableGroup.getTableReference(entityTableGroup.getNavigablePath(), (String)tableName);
            if (tableReference == null) {
                return;
            }
            NullnessPredicate predicate = new NullnessPredicate(new ColumnReference(tableReference, tableDiscriminatorDetails.getCheckColumnName(), false, null, null, this.getJdbcMapping(), this.getSessionFactory()), true);
            caseSearchedExpression.when(predicate, new QueryLiteral<Object>(tableDiscriminatorDetails.getDiscriminatorValue(), this.getUnderlyingJdbcMappingType()));
        });
        return caseSearchedExpression;
    }

    @Override
    public String getCustomReadExpression() {
        return null;
    }

    @Override
    public String getCustomWriteExpression() {
        return null;
    }

    @Override
    public String getContainingTableExpression() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSelectionExpression() {
        return "{discriminator}";
    }

    @Override
    public boolean isFormula() {
        return false;
    }

    private static class TableDiscriminatorDetails {
        private final String tableName;
        private final String checkColumnName;
        private final Object discriminatorValue;
        private final String subclassEntityName;

        public TableDiscriminatorDetails(String tableName, String checkColumnName, Object discriminatorValue, String subclassEntityName) {
            this.tableName = tableName;
            this.checkColumnName = checkColumnName;
            this.discriminatorValue = discriminatorValue;
            this.subclassEntityName = subclassEntityName;
        }

        String getTableExpression() {
            return this.tableName;
        }

        Object getDiscriminatorValue() {
            return this.discriminatorValue;
        }

        String getSubclassEntityName() {
            return this.subclassEntityName;
        }

        String getCheckColumnName() {
            return this.checkColumnName;
        }
    }
}

