/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.CascadeStyle;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.IndexedCollection;
import org.hibernate.mapping.IndexedConsumer;
import org.hibernate.mapping.List;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.metamodel.mapping.CollectionIdentifierDescriptor;
import org.hibernate.metamodel.mapping.CollectionMappingType;
import org.hibernate.metamodel.mapping.CollectionPart;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.ManagedMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.metamodel.mapping.StateArrayContributorMetadataAccess;
import org.hibernate.metamodel.mapping.internal.AbstractAttributeMapping;
import org.hibernate.metamodel.mapping.internal.DiscriminatedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EmbeddedCollectionPart;
import org.hibernate.metamodel.mapping.internal.EntityCollectionPart;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.metamodel.mapping.internal.NoValueGeneration;
import org.hibernate.metamodel.mapping.internal.SelectableMappingImpl;
import org.hibernate.metamodel.mapping.internal.SimpleForeignKeyDescriptor;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.metamodel.mapping.ordering.OrderByFragment;
import org.hibernate.metamodel.mapping.ordering.OrderByFragmentTranslator;
import org.hibernate.metamodel.mapping.ordering.TranslationContext;
import org.hibernate.metamodel.model.domain.NavigableRole;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.spi.FromClauseAccess;
import org.hibernate.sql.ast.spi.SqlAliasBase;
import org.hibernate.sql.ast.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.spi.SqlAliasStemHelper;
import org.hibernate.sql.ast.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.spi.SqlAstCreationState;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.StandardTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.Fetch;
import org.hibernate.sql.results.graph.FetchOptions;
import org.hibernate.sql.results.graph.FetchParent;
import org.hibernate.sql.results.graph.collection.internal.CollectionDomainResult;
import org.hibernate.sql.results.graph.collection.internal.DelayedCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.EagerCollectionFetch;
import org.hibernate.sql.results.graph.collection.internal.SelectEagerCollectionFetch;
import org.hibernate.tuple.ValueGeneration;
import org.hibernate.type.EntityType;
import org.jboss.logging.Logger;

public class PluralAttributeMappingImpl
extends AbstractAttributeMapping
implements PluralAttributeMapping,
FetchOptions {
    private static final Logger log = Logger.getLogger(PluralAttributeMappingImpl.class);
    private final CollectionMappingType collectionMappingType;
    private final int stateArrayPosition;
    private final PropertyAccess propertyAccess;
    private final StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess;
    private final String referencedPropertyName;
    private final CollectionPart elementDescriptor;
    private final CollectionPart indexDescriptor;
    private final CollectionIdentifierDescriptor identifierDescriptor;
    private final FetchTiming fetchTiming;
    private final FetchStyle fetchStyle;
    private final String bidirectionalAttributeName;
    private final CollectionPersister collectionDescriptor;
    private final String separateCollectionTable;
    private final String sqlAliasStem;
    private final PluralAttributeMapping.IndexMetadata indexMetadata;
    private ForeignKeyDescriptor fkDescriptor;
    private ForeignKeyDescriptor elementFkDescriptor;
    private ForeignKeyDescriptor indexFkDescriptor;
    private OrderByFragment orderByFragment;
    private OrderByFragment manyToManyOrderByFragment;

    public PluralAttributeMappingImpl(String attributeName, Collection bootDescriptor, PropertyAccess propertyAccess, StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess, CollectionMappingType collectionMappingType, int stateArrayPosition, CollectionPart elementDescriptor, CollectionPart indexDescriptor, CollectionIdentifierDescriptor identifierDescriptor, FetchOptions fetchOptions, CascadeStyle cascadeStyle, ManagedMappingType declaringType, CollectionPersister collectionDescriptor) {
        this(attributeName, bootDescriptor, propertyAccess, stateArrayContributorMetadataAccess, collectionMappingType, stateArrayPosition, elementDescriptor, indexDescriptor, identifierDescriptor, fetchOptions.getTiming(), fetchOptions.getStyle(), cascadeStyle, declaringType, collectionDescriptor);
    }

    public PluralAttributeMappingImpl(String attributeName, final Collection bootDescriptor, PropertyAccess propertyAccess, StateArrayContributorMetadataAccess stateArrayContributorMetadataAccess, CollectionMappingType collectionMappingType, int stateArrayPosition, CollectionPart elementDescriptor, final CollectionPart indexDescriptor, CollectionIdentifierDescriptor identifierDescriptor, FetchTiming fetchTiming, FetchStyle fetchStyle, CascadeStyle cascadeStyle, ManagedMappingType declaringType, CollectionPersister collectionDescriptor) {
        super(attributeName, declaringType);
        this.propertyAccess = propertyAccess;
        this.stateArrayContributorMetadataAccess = stateArrayContributorMetadataAccess;
        this.collectionMappingType = collectionMappingType;
        this.stateArrayPosition = stateArrayPosition;
        this.elementDescriptor = elementDescriptor;
        this.indexDescriptor = indexDescriptor;
        this.identifierDescriptor = identifierDescriptor;
        this.fetchTiming = fetchTiming;
        this.fetchStyle = fetchStyle;
        this.collectionDescriptor = collectionDescriptor;
        this.referencedPropertyName = bootDescriptor.getReferencedPropertyName();
        this.bidirectionalAttributeName = StringHelper.subStringNullIfEmpty(bootDescriptor.getMappedByProperty(), Character.valueOf('.'));
        this.sqlAliasStem = SqlAliasStemHelper.INSTANCE.generateStemFromAttributeName(attributeName);
        this.separateCollectionTable = bootDescriptor.isOneToMany() ? null : ((Joinable)((Object)collectionDescriptor)).getTableName();
        this.indexMetadata = new PluralAttributeMapping.IndexMetadata(){
            final int baseIndex;
            {
                this.baseIndex = bootDescriptor instanceof List ? ((List)bootDescriptor).getBaseIndex() : -1;
            }

            @Override
            public CollectionPart getIndexDescriptor() {
                return indexDescriptor;
            }

            @Override
            public int getListIndexBase() {
                return this.baseIndex;
            }
        };
        if (collectionDescriptor instanceof Aware) {
            ((Aware)((Object)collectionDescriptor)).injectAttributeMapping(this);
        }
        if (elementDescriptor instanceof Aware) {
            ((Aware)((Object)elementDescriptor)).injectAttributeMapping(this);
        }
        if (indexDescriptor instanceof Aware) {
            ((Aware)((Object)indexDescriptor)).injectAttributeMapping(this);
        }
    }

    @Override
    public boolean isBidirectionalAttributeName(NavigablePath fetchablePath, ToOneAttributeMapping modelPart) {
        if (this.bidirectionalAttributeName == null) {
            return this.fkDescriptor.getTargetPart() == modelPart.getForeignKeyDescriptor().getTargetPart();
        }
        return fetchablePath.getUnaliasedLocalName().endsWith(this.bidirectionalAttributeName);
    }

    public void finishInitialization(Property bootProperty, Collection bootDescriptor, MappingModelCreationProcess creationProcess) {
        boolean hasManyToManyOrder;
        Dialect dialect = creationProcess.getCreationContext().getSessionFactory().getJdbcServices().getDialect();
        if (this.collectionDescriptor.getElementType() instanceof EntityType) {
            creationProcess.registerForeignKeyPostInitCallbacks("To-many key - " + this.getNavigableRole(), () -> {
                this.elementFkDescriptor = this.createForeignKeyDescriptor(bootDescriptor.getElement(), (EntityType)this.collectionDescriptor.getElementType(), creationProcess, dialect);
                return true;
            });
        }
        if (this.collectionDescriptor.getIndexType() instanceof EntityType) {
            creationProcess.registerForeignKeyPostInitCallbacks("To-many index - " + this.getNavigableRole(), () -> {
                this.indexFkDescriptor = this.createForeignKeyDescriptor(((IndexedCollection)bootDescriptor).getIndex(), (EntityType)this.collectionDescriptor.getIndexType(), creationProcess, dialect);
                return true;
            });
        }
        boolean hasOrder = bootDescriptor.getOrderBy() != null;
        boolean bl = hasManyToManyOrder = bootDescriptor.getManyToManyOrdering() != null;
        if (hasOrder || hasManyToManyOrder) {
            TranslationContext context = () -> this.collectionDescriptor.getFactory().getSessionFactoryOptions().getJpaCompliance();
            if (hasOrder) {
                if (log.isDebugEnabled()) {
                    log.debugf("Translating order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                }
                this.orderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getOrderBy(), this, context);
            }
            if (hasManyToManyOrder) {
                if (log.isDebugEnabled()) {
                    log.debugf("Translating many-to-many order-by fragment [%s] for collection role : %s", (Object)bootDescriptor.getOrderBy(), (Object)this.collectionDescriptor.getRole());
                }
                this.manyToManyOrderByFragment = OrderByFragmentTranslator.translate(bootDescriptor.getManyToManyOrdering(), this, context);
            }
        }
    }

    private ForeignKeyDescriptor createForeignKeyDescriptor(Value fkBootDescriptorSource, EntityType entityType, MappingModelCreationProcess creationProcess, Dialect dialect) {
        EntityIdentifierMapping fkTargetPart;
        EntityPersister associatedEntityDescriptor = creationProcess.getEntityPersister(entityType.getAssociatedEntityName());
        ModelPart modelPart = fkTargetPart = entityType.isReferenceToPrimaryKey() ? associatedEntityDescriptor.getIdentifierMapping() : associatedEntityDescriptor.findSubPart(entityType.getRHSUniqueKeyPropertyName());
        if (fkTargetPart instanceof BasicValuedModelPart) {
            BasicValuedModelPart basicFkTargetPart = (BasicValuedModelPart)((Object)fkTargetPart);
            Joinable collectionDescriptorAsJoinable = (Joinable)((Object)this.collectionDescriptor);
            SelectableMapping keySelectableMapping = SelectableMappingImpl.from(collectionDescriptorAsJoinable.getTableName(), fkBootDescriptorSource.getColumnIterator().next(), basicFkTargetPart.getJdbcMapping(), dialect, creationProcess.getSqmFunctionRegistry());
            boolean hasConstraint = fkBootDescriptorSource instanceof SimpleValue ? ((SimpleValue)fkBootDescriptorSource).isConstrained() : !fkBootDescriptorSource.isNullable();
            return new SimpleForeignKeyDescriptor(basicFkTargetPart, null, keySelectableMapping, basicFkTargetPart, entityType.isReferenceToPrimaryKey(), hasConstraint);
        }
        if (fkTargetPart instanceof EmbeddableValuedModelPart) {
            return MappingModelCreationHelper.buildEmbeddableForeignKeyDescriptor((EmbeddableValuedModelPart)((Object)fkTargetPart), fkBootDescriptorSource, dialect, creationProcess);
        }
        throw new NotYetImplementedFor6Exception("Support for composite foreign keys not yet implemented : " + this.collectionDescriptor.getRole());
    }

    @Override
    public NavigableRole getNavigableRole() {
        return this.getCollectionDescriptor().getNavigableRole();
    }

    @Override
    public CollectionMappingType getMappedType() {
        return this.collectionMappingType;
    }

    @Override
    public ForeignKeyDescriptor getKeyDescriptor() {
        return this.fkDescriptor;
    }

    @Override
    public CollectionPersister getCollectionDescriptor() {
        return this.collectionDescriptor;
    }

    @Override
    public CollectionPart getElementDescriptor() {
        return this.elementDescriptor;
    }

    @Override
    public CollectionPart getIndexDescriptor() {
        return this.indexDescriptor;
    }

    @Override
    public PluralAttributeMapping.IndexMetadata getIndexMetadata() {
        return this.indexMetadata;
    }

    @Override
    public CollectionIdentifierDescriptor getIdentifierDescriptor() {
        return this.identifierDescriptor;
    }

    @Override
    public OrderByFragment getOrderByFragment() {
        return this.orderByFragment;
    }

    @Override
    public OrderByFragment getManyToManyOrderByFragment() {
        return this.manyToManyOrderByFragment;
    }

    @Override
    public String getSeparateCollectionTable() {
        return this.separateCollectionTable;
    }

    @Override
    public boolean containsTableReference(String tableExpression) {
        return tableExpression.equals(this.separateCollectionTable);
    }

    @Override
    public int getStateArrayPosition() {
        return this.stateArrayPosition;
    }

    @Override
    public StateArrayContributorMetadataAccess getAttributeMetadataAccess() {
        return this.stateArrayContributorMetadataAccess;
    }

    @Override
    public PropertyAccess getPropertyAccess() {
        return this.propertyAccess;
    }

    @Override
    public ValueGeneration getValueGeneration() {
        return NoValueGeneration.INSTANCE;
    }

    @Override
    public String getFetchableName() {
        return this.getAttributeName();
    }

    @Override
    public FetchOptions getMappedFetchOptions() {
        return this;
    }

    @Override
    public FetchStyle getStyle() {
        return this.fetchStyle;
    }

    @Override
    public FetchTiming getTiming() {
        return this.fetchTiming;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        TableGroup collectionTableGroup = creationState.getSqlAstCreationState().getFromClauseAccess().getTableGroup(navigablePath);
        assert (collectionTableGroup != null);
        return new CollectionDomainResult(navigablePath, this, resultVariable, tableGroup, creationState);
    }

    @Override
    public Fetch generateFetch(FetchParent fetchParent, NavigablePath fetchablePath, FetchTiming fetchTiming, boolean selected, String resultVariable, DomainResultCreationState creationState) {
        SqlAstCreationState sqlAstCreationState = creationState.getSqlAstCreationState();
        creationState.registerVisitedAssociationKey(this.fkDescriptor.getAssociationKey());
        if (fetchTiming == FetchTiming.IMMEDIATE) {
            if (selected) {
                TableGroup collectionTableGroup = this.resolveCollectionTableGroup(fetchParent, fetchablePath, creationState, sqlAstCreationState);
                return new EagerCollectionFetch(fetchablePath, this, collectionTableGroup, fetchParent, creationState);
            }
            return this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
        }
        if (this.getCollectionDescriptor().getCollectionType().hasHolder()) {
            return this.createSelectEagerCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
        }
        return this.createDelayedCollectionFetch(fetchParent, fetchablePath, creationState, sqlAstCreationState);
    }

    private Fetch createSelectEagerCollectionFetch(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        if (this.referencedPropertyName != null) {
            this.resolveCollectionTableGroup(fetchParent, fetchablePath, creationState, sqlAstCreationState);
            DomainResult<?> collectionKeyDomainResult = this.getKeyDescriptor().createTargetDomainResult(fetchablePath, sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath()), creationState);
            return new SelectEagerCollectionFetch(fetchablePath, this, collectionKeyDomainResult, fetchParent);
        }
        return new SelectEagerCollectionFetch(fetchablePath, this, null, fetchParent);
    }

    private TableGroup resolveCollectionTableGroup(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        FromClauseAccess fromClauseAccess = sqlAstCreationState.getFromClauseAccess();
        return fromClauseAccess.resolveTableGroup(fetchablePath, p -> {
            TableGroup lhsTableGroup = fromClauseAccess.getTableGroup(fetchParent.getNavigablePath());
            TableGroupJoin tableGroupJoin = this.createTableGroupJoin(fetchablePath, lhsTableGroup, null, SqlAstJoinType.LEFT, true, creationState.getSqlAstCreationState());
            return tableGroupJoin.getJoinedGroup();
        });
    }

    private Fetch createDelayedCollectionFetch(FetchParent fetchParent, NavigablePath fetchablePath, DomainResultCreationState creationState, SqlAstCreationState sqlAstCreationState) {
        EntityMappingType containingEntityMapping = this.findContainingEntityMapping();
        DomainResult<?> collectionKeyDomainResult = fetchParent.getReferencedModePart() == containingEntityMapping && containingEntityMapping.getEntityPersister().getPropertyLaziness()[this.getStateArrayPosition()] ? null : this.getKeyDescriptor().createTargetDomainResult(fetchablePath, sqlAstCreationState.getFromClauseAccess().getTableGroup(fetchParent.getNavigablePath()), creationState);
        return new DelayedCollectionFetch(fetchablePath, this, fetchParent, collectionKeyDomainResult);
    }

    @Override
    public String getSqlAliasStem() {
        return this.sqlAliasStem;
    }

    @Override
    public SqlAstJoinType getDefaultSqlAstJoinType(TableGroup parentTableGroup) {
        return SqlAstJoinType.LEFT;
    }

    @Override
    public TableGroupJoin createTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        CollectionPersister collectionDescriptor = this.getCollectionDescriptor();
        if (collectionDescriptor.isOneToMany()) {
            return this.createOneToManyTableGroupJoin(navigablePath, lhs, explicitSourceAlias, sqlAstJoinType, fetched, aliasBaseGenerator, sqlExpressionResolver, creationContext);
        }
        return this.createCollectionTableGroupJoin(navigablePath, lhs, explicitSourceAlias, sqlAstJoinType, fetched, aliasBaseGenerator, sqlExpressionResolver, creationContext);
    }

    @Override
    public void setForeignKeyDescriptor(ForeignKeyDescriptor fkDescriptor) {
        this.fkDescriptor = fkDescriptor;
    }

    private TableGroupJoin createOneToManyTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableGroup tableGroup = this.createOneToManyTableGroup(lhs.canUseInnerJoins() && sqlAstJoinType == SqlAstJoinType.INNER, navigablePath, fetched, explicitSourceAlias, aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem()), sqlExpressionResolver, creationContext);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, this.getKeyDescriptor().generateJoinPredicate(lhs, tableGroup, sqlAstJoinType, sqlExpressionResolver, creationContext));
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    private TableGroup createOneToManyTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        EntityMappingType elementDescriptorEntityMappingType;
        if (this.elementDescriptor instanceof EntityCollectionPart) {
            elementDescriptorEntityMappingType = ((EntityCollectionPart)this.elementDescriptor).getEntityMappingType();
        } else {
            assert (this.indexDescriptor instanceof EntityCollectionPart);
            elementDescriptorEntityMappingType = null;
        }
        EntityMappingType indexDescriptorEntityMappingType = this.indexDescriptor instanceof EntityCollectionPart ? ((EntityCollectionPart)this.indexDescriptor).getEntityMappingType() : null;
        if (indexDescriptorEntityMappingType == null || elementDescriptorEntityMappingType == null) {
            EntityMappingType entityMappingType = indexDescriptorEntityMappingType == null ? elementDescriptorEntityMappingType.getEntityMappingType() : indexDescriptorEntityMappingType.getEntityMappingType();
            TableReference primaryTableReference = entityMappingType.createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
            return new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, true, sqlAliasBase, entityMappingType::containsTableReference, (tableExpression, tg) -> entityMappingType.createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, sqlExpressionResolver, creationContext), creationContext.getSessionFactory());
        }
        TableReference primaryTableReference = elementDescriptorEntityMappingType.createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        java.util.function.Predicate<String> tableReferenceJoinNameChecker = this.createTableReferenceJoinNameChecker(elementDescriptorEntityMappingType, indexDescriptorEntityMappingType);
        TableReference indexAssociatedPrimaryTable = indexDescriptorEntityMappingType.createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
        Function<TableGroup, TableReferenceJoin> indexTableGroupFinalizer = this.createTableGroupFinalizer(sqlExpressionResolver, creationContext, primaryTableReference, indexAssociatedPrimaryTable, SqlAstJoinType.INNER, this.indexFkDescriptor);
        BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator = (tableExpression, tableGroup) -> {
            if (elementDescriptorEntityMappingType.containsTableReference((String)tableExpression)) {
                return elementDescriptorEntityMappingType.createTableReferenceJoin((String)tableExpression, sqlAliasBase, primaryTableReference, sqlExpressionResolver, creationContext);
            }
            if (indexDescriptorEntityMappingType.containsTableReference((String)tableExpression)) {
                return this.createTableReferenceJoin(sqlExpressionResolver, creationContext, sqlAliasBase, indexDescriptorEntityMappingType, indexAssociatedPrimaryTable, indexTableGroupFinalizer, (String)tableExpression, (TableGroup)tableGroup);
            }
            throw new IllegalStateException("could not create join for table `" + tableExpression + "`");
        };
        return new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, primaryTableReference, true, sqlAliasBase, tableReferenceJoinNameChecker, tableReferenceJoinCreator, creationContext.getSessionFactory());
    }

    private TableGroupJoin createCollectionTableGroupJoin(NavigablePath navigablePath, TableGroup lhs, String explicitSourceAlias, SqlAstJoinType sqlAstJoinType, boolean fetched, SqlAliasBaseGenerator aliasBaseGenerator, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        TableGroup tableGroup = this.createCollectionTableGroup(lhs.canUseInnerJoins() && sqlAstJoinType == SqlAstJoinType.INNER, navigablePath, fetched, explicitSourceAlias, aliasBaseGenerator.createSqlAliasBase(this.getSqlAliasStem()), sqlExpressionResolver, creationContext);
        TableGroupJoin tableGroupJoin = new TableGroupJoin(navigablePath, sqlAstJoinType, tableGroup, this.getKeyDescriptor().generateJoinPredicate(lhs, tableGroup, sqlAstJoinType, sqlExpressionResolver, creationContext));
        lhs.addTableGroupJoin(tableGroupJoin);
        return tableGroupJoin;
    }

    private TableGroup createCollectionTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, boolean fetched, String sourceAlias, SqlAliasBase sqlAliasBase, SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext) {
        Function<TableGroup, TableReferenceJoin> indexTableGroupFinalizer;
        TableReference indexAssociatedPrimaryTable;
        Function<TableGroup, TableReferenceJoin> elementTableGroupFinalizer;
        TableReference elementAssociatedPrimaryTable;
        assert (!this.getCollectionDescriptor().isOneToMany());
        String collectionTableName = ((Joinable)((Object)this.collectionDescriptor)).getTableName();
        TableReference collectionTableReference = new TableReference(collectionTableName, sqlAliasBase.generateNewAlias(), true, creationContext.getSessionFactory());
        EntityMappingType elementDescriptorEntityMappingType = this.elementDescriptor instanceof EntityCollectionPart ? ((EntityCollectionPart)this.elementDescriptor).getEntityMappingType() : null;
        EntityMappingType indexDescriptorEntityMappingType = this.indexDescriptor instanceof EntityCollectionPart ? ((EntityCollectionPart)this.indexDescriptor).getEntityMappingType() : null;
        java.util.function.Predicate<String> tableReferenceJoinNameChecker = this.createTableReferenceJoinNameChecker(elementDescriptorEntityMappingType, indexDescriptorEntityMappingType);
        if (elementDescriptorEntityMappingType != null) {
            elementAssociatedPrimaryTable = elementDescriptorEntityMappingType.createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
            elementTableGroupFinalizer = this.createTableGroupFinalizer(sqlExpressionResolver, creationContext, collectionTableReference, elementAssociatedPrimaryTable, SqlAstJoinType.INNER, this.elementFkDescriptor);
        } else {
            elementAssociatedPrimaryTable = null;
            elementTableGroupFinalizer = null;
        }
        if (indexDescriptorEntityMappingType != null) {
            indexAssociatedPrimaryTable = indexDescriptorEntityMappingType.createPrimaryTableReference(sqlAliasBase, sqlExpressionResolver, creationContext);
            indexTableGroupFinalizer = this.createTableGroupFinalizer(sqlExpressionResolver, creationContext, collectionTableReference, indexAssociatedPrimaryTable, SqlAstJoinType.INNER, this.indexFkDescriptor);
        } else {
            indexAssociatedPrimaryTable = null;
            indexTableGroupFinalizer = null;
        }
        BiFunction<String, TableGroup, TableReferenceJoin> tableReferenceJoinCreator = elementDescriptorEntityMappingType != null || indexDescriptorEntityMappingType != null ? (tableExpression, tableGroup) -> {
            if (elementDescriptorEntityMappingType != null && elementDescriptorEntityMappingType.containsTableReference((String)tableExpression)) {
                return this.createTableReferenceJoin(sqlExpressionResolver, creationContext, sqlAliasBase, elementDescriptorEntityMappingType, elementAssociatedPrimaryTable, elementTableGroupFinalizer, (String)tableExpression, (TableGroup)tableGroup);
            }
            if (indexDescriptorEntityMappingType != null && indexDescriptorEntityMappingType.containsTableReference((String)tableExpression)) {
                return this.createTableReferenceJoin(sqlExpressionResolver, creationContext, sqlAliasBase, indexDescriptorEntityMappingType, indexAssociatedPrimaryTable, indexTableGroupFinalizer, (String)tableExpression, (TableGroup)tableGroup);
            }
            throw new IllegalStateException("could not create join for table `" + tableExpression + "`");
        } : (tableExpression, tableGroup) -> {
            throw new UnsupportedOperationException("element-collection cannot contain joins : " + collectionTableReference.getTableExpression() + " -> " + tableExpression);
        };
        StandardTableGroup tableGroup2 = new StandardTableGroup(canUseInnerJoins, navigablePath, this, fetched, sourceAlias, collectionTableReference, true, sqlAliasBase, tableReferenceJoinNameChecker, tableReferenceJoinCreator, creationContext.getSessionFactory());
        return tableGroup2;
    }

    private TableReferenceJoin createTableReferenceJoin(SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext, SqlAliasBase sqlAliasBase, EntityMappingType elementDescriptorEntityMappingType, TableReference elementAssociatedPrimaryTable, Function<TableGroup, TableReferenceJoin> elementTableGroupFinalizer, String tableExpression, TableGroup tableGroup) {
        if (elementAssociatedPrimaryTable.getTableExpression().equals(tableExpression)) {
            return elementTableGroupFinalizer.apply(tableGroup);
        }
        StandardTableGroup standardTableGroup = (StandardTableGroup)tableGroup;
        TableReferenceJoin elementTableReferenceJoin = standardTableGroup.getTableReferenceJoins().isEmpty() ? elementTableGroupFinalizer.apply(tableGroup) : null;
        TableReferenceJoin tableReferenceJoin = elementDescriptorEntityMappingType.createTableReferenceJoin(tableExpression, sqlAliasBase, elementAssociatedPrimaryTable, sqlExpressionResolver, creationContext);
        if (tableReferenceJoin != null && elementTableReferenceJoin != null) {
            ((StandardTableGroup)tableGroup).addTableReferenceJoin(elementTableReferenceJoin);
            return tableReferenceJoin;
        }
        return elementTableReferenceJoin == null ? tableReferenceJoin : elementTableReferenceJoin;
    }

    private Function<TableGroup, TableReferenceJoin> createTableGroupFinalizer(SqlExpressionResolver sqlExpressionResolver, SqlAstCreationContext creationContext, TableReference collectionTableReference, TableReference elementAssociatedPrimaryTable, SqlAstJoinType joinType, ForeignKeyDescriptor elementFkDescriptor) {
        return tableGroup -> {
            TableReferenceJoin associationJoin = new TableReferenceJoin(joinType, elementAssociatedPrimaryTable, elementFkDescriptor.generateJoinPredicate(collectionTableReference, elementAssociatedPrimaryTable, joinType, sqlExpressionResolver, creationContext));
            return associationJoin;
        };
    }

    private java.util.function.Predicate<String> createTableReferenceJoinNameChecker(EntityMappingType elementDescriptorEntityMappingType, EntityMappingType indexDescriptorEntityMappingType) {
        return tableExpression -> {
            if (elementDescriptorEntityMappingType != null && elementDescriptorEntityMappingType.containsTableReference((String)tableExpression)) {
                return true;
            }
            return indexDescriptorEntityMappingType != null && indexDescriptorEntityMappingType.containsTableReference((String)tableExpression);
        };
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAstCreationState creationState, SqlAstCreationContext creationContext) {
        return this.createRootTableGroup(canUseInnerJoins, navigablePath, explicitSourceAlias, additionalPredicateCollectorAccess, creationState.getSqlAliasBaseGenerator().createSqlAliasBase(this.getSqlAliasStem()), creationState, creationContext);
    }

    @Override
    public TableGroup createRootTableGroup(boolean canUseInnerJoins, NavigablePath navigablePath, String explicitSourceAlias, Supplier<Consumer<Predicate>> additionalPredicateCollectorAccess, SqlAliasBase sqlAliasBase, SqlAstCreationState creationState, SqlAstCreationContext creationContext) {
        if (this.getCollectionDescriptor().isOneToMany()) {
            return this.createOneToManyTableGroup(canUseInnerJoins, navigablePath, false, explicitSourceAlias, sqlAliasBase, creationState.getSqlExpressionResolver(), creationContext);
        }
        return this.createCollectionTableGroup(canUseInnerJoins, navigablePath, false, explicitSourceAlias, sqlAliasBase, creationState.getSqlExpressionResolver(), creationContext);
    }

    @Override
    public boolean isAffectedByEnabledFilters(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFilters(influencers);
    }

    @Override
    public boolean isAffectedByEntityGraph(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEntityGraph(influencers);
    }

    @Override
    public boolean isAffectedByEnabledFetchProfiles(LoadQueryInfluencers influencers) {
        return this.getCollectionDescriptor().isAffectedByEnabledFetchProfiles(influencers);
    }

    @Override
    public String getRootPathName() {
        return this.getCollectionDescriptor().getRole();
    }

    @Override
    public ModelPart findSubPart(String name, EntityMappingType treatTargetType) {
        CollectionPart.Nature nature = CollectionPart.Nature.fromName(name);
        if (nature == CollectionPart.Nature.ELEMENT) {
            return this.elementDescriptor;
        }
        if (nature == CollectionPart.Nature.INDEX) {
            return this.indexDescriptor;
        }
        if (nature == CollectionPart.Nature.ID) {
            return this.identifierDescriptor;
        }
        if (this.elementDescriptor instanceof EntityCollectionPart) {
            return ((EntityCollectionPart)this.elementDescriptor).findSubPart(name);
        }
        if (this.elementDescriptor instanceof EmbeddedCollectionPart) {
            return ((EmbeddedCollectionPart)this.elementDescriptor).findSubPart(name, treatTargetType);
        }
        if (this.elementDescriptor instanceof DiscriminatedCollectionPart) {
            return ((DiscriminatedCollectionPart)this.elementDescriptor).findSubPart(name, treatTargetType);
        }
        return null;
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState) {
        this.elementDescriptor.applySqlSelections(navigablePath, tableGroup, creationState);
    }

    @Override
    public void applySqlSelections(NavigablePath navigablePath, TableGroup tableGroup, DomainResultCreationState creationState, BiConsumer<SqlSelection, JdbcMapping> selectionConsumer) {
        this.elementDescriptor.applySqlSelections(navigablePath, tableGroup, creationState, selectionConsumer);
    }

    @Override
    public void breakDownJdbcValues(Object domainValue, ModelPart.JdbcValueConsumer valueConsumer, SharedSessionContractImplementor session) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void visitSubParts(Consumer<ModelPart> consumer, EntityMappingType treatTargetType) {
        consumer.accept(this.elementDescriptor);
        if (this.indexDescriptor != null) {
            consumer.accept(this.indexDescriptor);
        }
    }

    @Override
    public int getJdbcTypeCount() {
        int span = this.elementDescriptor.getJdbcTypeCount();
        if (this.indexDescriptor != null) {
            span += this.indexDescriptor.getJdbcTypeCount();
        }
        return span;
    }

    @Override
    public int forEachJdbcType(int offset, IndexedConsumer<JdbcMapping> action) {
        int span = this.elementDescriptor.forEachJdbcType(offset, action);
        if (this.indexDescriptor != null) {
            span += this.indexDescriptor.forEachJdbcType(offset + span, action);
        }
        return span;
    }

    @Override
    public Object disassemble(Object value, SharedSessionContractImplementor session) {
        return this.elementDescriptor.disassemble(value, session);
    }

    @Override
    public int getNumberOfFetchables() {
        return this.indexDescriptor == null ? 1 : 2;
    }

    public String toString() {
        return "PluralAttribute(" + this.getCollectionDescriptor().getRole() + ")";
    }

    public static interface Aware {
        public void injectAttributeMapping(PluralAttributeMapping var1);
    }
}

