/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.mapping.internal;

import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.Selectable;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.SelectableMapping;
import org.hibernate.query.sqm.function.SqmFunctionRegistry;

public class SelectableMappingImpl
implements SelectableMapping {
    private final String containingTableExpression;
    private final String selectionExpression;
    private final String customReadExpression;
    private final String customWriteExpression;
    private final boolean isFormula;
    private final JdbcMapping jdbcMapping;

    public SelectableMappingImpl(String containingTableExpression, String selectionExpression, String customReadExpression, String customWriteExpression, boolean isFormula, JdbcMapping jdbcMapping) {
        this.containingTableExpression = containingTableExpression == null ? null : containingTableExpression.intern();
        this.selectionExpression = selectionExpression == null ? null : selectionExpression.intern();
        this.customReadExpression = customReadExpression == null ? null : customReadExpression.intern();
        this.customWriteExpression = customWriteExpression == null ? null : customWriteExpression.intern();
        this.isFormula = isFormula;
        this.jdbcMapping = jdbcMapping;
    }

    public static SelectableMapping from(String containingTableExpression, Selectable selectable, JdbcMapping jdbcMapping, Dialect dialect, SqmFunctionRegistry sqmFunctionRegistry) {
        String columnExpression = selectable.isFormula() ? selectable.getTemplate(dialect, sqmFunctionRegistry) : selectable.getText(dialect);
        return new SelectableMappingImpl(containingTableExpression, columnExpression, selectable.getCustomReadExpression(), selectable.getCustomWriteExpression(), selectable.isFormula(), jdbcMapping);
    }

    @Override
    public String getContainingTableExpression() {
        return this.containingTableExpression;
    }

    @Override
    public String getSelectionExpression() {
        return this.selectionExpression;
    }

    @Override
    public String getCustomReadExpression() {
        return this.customReadExpression;
    }

    @Override
    public String getCustomWriteExpression() {
        return this.customWriteExpression;
    }

    @Override
    public boolean isFormula() {
        return this.isFormula;
    }

    @Override
    public JdbcMapping getJdbcMapping() {
        return this.jdbcMapping;
    }
}

