/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import jakarta.persistence.AttributeConverter;
import org.hibernate.boot.model.convert.spi.JpaAttributeConverterCreationContext;
import org.hibernate.metamodel.model.convert.spi.JpaAttributeConverter;
import org.hibernate.resource.beans.spi.ManagedBean;
import org.hibernate.type.descriptor.converter.AttributeConverterMutabilityPlanImpl;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptorRegistry;
import org.hibernate.type.descriptor.java.spi.RegistryHelper;

public class JpaAttributeConverterImpl<O, R>
implements JpaAttributeConverter<O, R> {
    private final ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean;
    private final JavaType<? extends AttributeConverter<O, R>> converterJtd;
    private final JavaType<O> domainJtd;
    private final JavaType<R> jdbcJtd;

    public JpaAttributeConverterImpl(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, JavaType<? extends AttributeConverter<O, R>> converterJtd, JavaType<O> domainJtd, JavaType<R> jdbcJtd) {
        this.attributeConverterBean = attributeConverterBean;
        this.converterJtd = converterJtd;
        this.domainJtd = domainJtd;
        this.jdbcJtd = jdbcJtd;
    }

    public JpaAttributeConverterImpl(ManagedBean<? extends AttributeConverter<O, R>> attributeConverterBean, JavaType<? extends AttributeConverter<O, R>> converterJtd, Class<O> domainJavaType, Class<R> jdbcJavaType, JpaAttributeConverterCreationContext context) {
        this.attributeConverterBean = attributeConverterBean;
        this.converterJtd = converterJtd;
        JavaTypeDescriptorRegistry jtdRegistry = context.getJavaTypeDescriptorRegistry();
        this.jdbcJtd = jtdRegistry.getDescriptor(jdbcJavaType);
        this.domainJtd = jtdRegistry.resolveDescriptor(domainJavaType, () -> RegistryHelper.INSTANCE.createTypeDescriptor(domainJavaType, () -> {
            Class converterClass = attributeConverterBean.getBeanClass();
            MutabilityPlan mutabilityPlan = RegistryHelper.INSTANCE.determineMutabilityPlan(converterClass, context.getTypeConfiguration());
            if (mutabilityPlan != null) {
                return mutabilityPlan;
            }
            return new AttributeConverterMutabilityPlanImpl(this, true);
        }, context.getTypeConfiguration()));
    }

    @Override
    public ManagedBean<? extends AttributeConverter<O, R>> getConverterBean() {
        return this.attributeConverterBean;
    }

    @Override
    public O toDomainValue(R relationalForm) {
        return (O)this.attributeConverterBean.getBeanInstance().convertToEntityAttribute(relationalForm);
    }

    @Override
    public R toRelationalValue(O domainForm) {
        return (R)this.attributeConverterBean.getBeanInstance().convertToDatabaseColumn(domainForm);
    }

    @Override
    public JavaType<? extends AttributeConverter<O, R>> getConverterJavaTypeDescriptor() {
        return this.converterJtd;
    }

    @Override
    public JavaType<O> getDomainJavaDescriptor() {
        return this.getDomainJavaTypeDescriptor();
    }

    @Override
    public JavaType<R> getRelationalJavaDescriptor() {
        return this.getRelationalJavaTypeDescriptor();
    }

    @Override
    public JavaType<O> getDomainJavaTypeDescriptor() {
        return this.domainJtd;
    }

    @Override
    public JavaType<R> getRelationalJavaTypeDescriptor() {
        return this.jdbcJtd;
    }
}

