/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Attribute;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Member;
import org.hibernate.metamodel.AttributeClassification;
import org.hibernate.metamodel.internal.MetadataContext;
import org.hibernate.metamodel.model.domain.ManagedDomainType;
import org.hibernate.metamodel.model.domain.PersistentAttribute;
import org.hibernate.metamodel.model.domain.SimpleDomainType;
import org.hibernate.type.descriptor.java.JavaType;

public abstract class AbstractAttribute<D, J, B>
implements PersistentAttribute<D, J>,
Serializable {
    private final ManagedDomainType<D> declaringType;
    private final String name;
    private final JavaType<J> attributeJtd;
    private final AttributeClassification attributeClassification;
    private final SimpleDomainType<B> valueType;
    private transient Member member;

    protected AbstractAttribute(ManagedDomainType<D> declaringType, String name, JavaType<J> attributeJtd, AttributeClassification attributeClassification, SimpleDomainType<B> valueType, Member member, MetadataContext metadataContext) {
        this.declaringType = declaringType;
        this.name = name;
        this.attributeJtd = attributeJtd;
        this.attributeClassification = attributeClassification;
        this.valueType = valueType;
        this.member = member;
    }

    public String getName() {
        return this.name;
    }

    public Class<J> getJavaType() {
        return this.attributeJtd.getJavaTypeClass();
    }

    public SimpleDomainType<B> getSqmPathType() {
        return this.valueType;
    }

    @Override
    public JavaType<J> getAttributeJavaTypeDescriptor() {
        return this.attributeJtd;
    }

    @Override
    public ManagedDomainType<D> getDeclaringType() {
        return this.declaringType;
    }

    public Member getJavaMember() {
        return this.member;
    }

    @Override
    public AttributeClassification getAttributeClassification() {
        return this.attributeClassification;
    }

    public Attribute.PersistentAttributeType getPersistentAttributeType() {
        return this.getAttributeClassification().getJpaClassification();
    }

    @Override
    public SimpleDomainType<?> getValueGraphType() {
        return this.valueType;
    }

    public String toString() {
        return this.declaringType.getTypeName() + '#' + this.name + '(' + (Object)((Object)this.attributeClassification) + ')';
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new SerialForm(this.declaringType, this.name);
    }

    private static class SerialForm
    implements Serializable {
        private final ManagedDomainType<?> declaringType;
        private final String name;

        public SerialForm(ManagedDomainType<?> declaringType, String name) {
            this.declaringType = declaringType;
            this.name = name;
        }

        private Object readResolve() {
            return this.declaringType.findAttribute(this.name);
        }
    }
}

