/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain.internal;

import jakarta.persistence.metamodel.Type;
import java.util.Arrays;
import java.util.List;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AllowableFunctionReturnType;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.metamodel.model.domain.TupleType;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.ObjectArrayJavaTypeDescriptor;

public class ArrayTupleType
implements TupleType<Object[]>,
AllowableParameterType<Object[]>,
AllowableFunctionReturnType<Object[]>,
MappingModelExpressable {
    private final ObjectArrayJavaTypeDescriptor javaTypeDescriptor;
    private final SqmExpressable<?>[] components;

    public ArrayTupleType(SqmExpressable<?>[] components) {
        this.components = components;
        this.javaTypeDescriptor = new ObjectArrayJavaTypeDescriptor(ArrayTupleType.getTypeDescriptors(components));
    }

    private static JavaType<?>[] getTypeDescriptors(SqmExpressable<?>[] components) {
        JavaType[] typeDescriptors = new JavaType[components.length];
        for (int i = 0; i < components.length; ++i) {
            typeDescriptors[i] = components[i].getExpressableJavaTypeDescriptor();
        }
        return typeDescriptors;
    }

    @Override
    public int componentCount() {
        return this.components.length;
    }

    @Override
    public String getComponentName(int index) {
        throw new UnsupportedOperationException("Array tuple has no component names");
    }

    @Override
    public List<String> getComponentNames() {
        throw new UnsupportedOperationException("Array tuple has no component names");
    }

    @Override
    public SqmExpressable<?> get(int index) {
        return this.components[index];
    }

    @Override
    public SqmExpressable<?> get(String componentName) {
        throw new UnsupportedOperationException("Array tuple has no component names");
    }

    @Override
    public JavaType<Object[]> getExpressableJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public Type.PersistenceType getPersistenceType() {
        return Type.PersistenceType.EMBEDDABLE;
    }

    public Class<Object[]> getJavaType() {
        return this.getExpressableJavaTypeDescriptor().getJavaTypeClass();
    }

    public String toString() {
        return "ArrayTupleType" + Arrays.toString(this.components);
    }
}

