/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.boot.model.relational.Database;
import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.cache.spi.access.NaturalIdDataAccess;
import org.hibernate.engine.jdbc.env.spi.JdbcEnvironment;
import org.hibernate.engine.spi.ExecuteUpdateResultCheckStyle;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.DynamicFilterAliasGenerator;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.util.MarkerObject;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityVersionMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.internal.BasicEntityIdentifierMappingImpl;
import org.hibernate.metamodel.mapping.internal.CaseStatementDiscriminatorMappingImpl;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationHelper;
import org.hibernate.metamodel.mapping.internal.MappingModelCreationProcess;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.persister.entity.DiscriminatorType;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.persister.spi.PersisterCreationContext;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.Insert;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.entity.internal.EntityResultJoinedSubclassImpl;
import org.hibernate.type.BasicType;
import org.hibernate.type.CompositeType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class JoinedSubclassEntityPersister
extends AbstractEntityPersister {
    private static final Logger log = Logger.getLogger(JoinedSubclassEntityPersister.class);
    private static final String IMPLICIT_DISCRIMINATOR_ALIAS = "clazz_";
    private static final Object NULL_DISCRIMINATOR = new MarkerObject("<null discriminator>");
    private static final Object NOT_NULL_DISCRIMINATOR = new MarkerObject("<not null discriminator>");
    private final int tableSpan;
    private final String[] tableNames;
    private final String[] naturalOrderTableNames;
    private final String[][] tableKeyColumns;
    private final String[][] tableKeyColumnReaders;
    private final String[][] tableKeyColumnReaderTemplates;
    private final String[][] naturalOrderTableKeyColumns;
    private final String[][] naturalOrderTableKeyColumnReaders;
    private final String[][] naturalOrderTableKeyColumnReaderTemplates;
    private final boolean[] naturalOrderCascadeDeleteEnabled;
    private final String[] spaces;
    private final String[] subclassClosure;
    private final String[] subclassTableNameClosure;
    private final String[][] subclassTableKeyColumnClosure;
    private final boolean[] isClassOrSuperclassTable;
    private final int[] naturalOrderPropertyTableNumbers;
    private final int[] propertyTableNumbers;
    private final int[] subclassPropertyTableNumberClosure;
    private final int[] subclassColumnTableNumberClosure;
    private final int[] subclassFormulaTableNumberClosure;
    private final boolean[] subclassTableSequentialSelect;
    private final boolean[] subclassTableIsLazyClosure;
    private final boolean[] isInverseSubclassTable;
    private final boolean[] isNullableSubclassTable;
    private final Map<Object, String> subclassesByDiscriminatorValue = new HashMap<Object, String>();
    private final String[] discriminatorValues;
    private final String[] notNullColumnNames;
    private final int[] notNullColumnTableNumbers;
    private final String[] constraintOrderedTableNames;
    private final String[][] constraintOrderedKeyColumnNames;
    private final Object discriminatorValue;
    private final String discriminatorSQLString;
    private final BasicType<?> discriminatorType;
    private final String explicitDiscriminatorColumnName;
    private final String discriminatorAlias;
    private final int coreTableSpan;
    private final boolean[] isNullableTable;
    private final boolean[] isInverseTable;
    private final Map<String, Object> discriminatorValuesByTableName;
    private final Map<String, String> discriminatorColumnNameByTableName;
    private final Map<String, String> subclassNameByTableName;
    private final String[][] subclassNamesBySubclassTable;

    public JoinedSubclassEntityPersister(PersistentClass persistentClass, EntityDataAccess cacheAccessStrategy, NaturalIdDataAccess naturalIdRegionAccessStrategy, PersisterCreationContext creationContext) throws HibernateException {
        super(persistentClass, cacheAccessStrategy, naturalIdRegionAccessStrategy, creationContext);
        int k;
        Iterator<Selectable> cItr;
        SessionFactoryImplementor factory = creationContext.getSessionFactory();
        Database database = creationContext.getMetadata().getDatabase();
        JdbcEnvironment jdbcEnvironment = database.getJdbcEnvironment();
        if (persistentClass.isPolymorphic()) {
            Value discriminatorMapping = persistentClass.getDiscriminator();
            if (discriminatorMapping != null) {
                log.debug((Object)"Encountered explicit discriminator mapping for joined inheritance");
                Selectable selectable = discriminatorMapping.getColumnIterator().next();
                if (selectable instanceof Formula) {
                    throw new MappingException("Discriminator formulas on joined inheritance hierarchies not supported at this time");
                }
                Column column = (Column)selectable;
                this.explicitDiscriminatorColumnName = column.getQuotedName(factory.getDialect());
                this.discriminatorAlias = column.getAlias(factory.getDialect(), persistentClass.getRootTable());
                this.discriminatorType = (BasicType)persistentClass.getDiscriminator().getType();
                if (persistentClass.isDiscriminatorValueNull()) {
                    this.discriminatorValue = NULL_DISCRIMINATOR;
                    this.discriminatorSQLString = "null";
                } else if (persistentClass.isDiscriminatorValueNotNull()) {
                    this.discriminatorValue = NOT_NULL_DISCRIMINATOR;
                    this.discriminatorSQLString = "not null";
                } else {
                    try {
                        this.discriminatorValue = this.discriminatorType.getJavaTypeDescriptor().fromString(persistentClass.getDiscriminatorValue());
                        this.discriminatorSQLString = this.discriminatorType.getJdbcTypeDescriptor().getJdbcLiteralFormatter(this.discriminatorType.getJavaTypeDescriptor()).toJdbcLiteral(this.discriminatorValue, factory.getJdbcServices().getDialect(), factory.getWrapperOptions());
                    }
                    catch (ClassCastException cce) {
                        throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                    }
                    catch (Exception e) {
                        throw new MappingException("Could not format discriminator value to SQL string", e);
                    }
                }
            } else {
                this.explicitDiscriminatorColumnName = null;
                this.discriminatorAlias = IMPLICIT_DISCRIMINATOR_ALIAS;
                this.discriminatorType = factory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
                try {
                    this.discriminatorValue = persistentClass.getSubclassId();
                    this.discriminatorSQLString = this.discriminatorValue.toString();
                }
                catch (Exception e) {
                    throw new MappingException("Could not format discriminator value to SQL string", e);
                }
            }
        } else {
            this.explicitDiscriminatorColumnName = null;
            this.discriminatorAlias = IMPLICIT_DISCRIMINATOR_ALIAS;
            this.discriminatorType = factory.getTypeConfiguration().getBasicTypeRegistry().resolve(StandardBasicTypes.INTEGER);
            this.discriminatorValue = null;
            this.discriminatorSQLString = null;
        }
        if (this.optimisticLockStyle().isAllOrDirty()) {
            throw new MappingException("optimistic-lock=all|dirty not supported for joined-subclass mappings [" + this.getEntityName() + "]");
        }
        int idColumnSpan = this.getIdentifierColumnSpan();
        ArrayList<String> tableNames = new ArrayList<String>();
        ArrayList<Object> keyColumns = new ArrayList<String[]>();
        ArrayList<String[]> keyColumnReaders = new ArrayList<String[]>();
        ArrayList<String[]> keyColumnReaderTemplates = new ArrayList<String[]>();
        ArrayList<Boolean> cascadeDeletes = new ArrayList<Boolean>();
        Iterator<Table> tItr = persistentClass.getTableClosureIterator();
        Iterator<KeyValue> kItr = persistentClass.getKeyClosureIterator();
        while (tItr.hasNext()) {
            Table table = tItr.next();
            KeyValue key = kItr.next();
            String tableName = this.determineTableName(table, jdbcEnvironment);
            tableNames.add(tableName);
            String[] keyCols = new String[idColumnSpan];
            String[] keyColReaders = new String[idColumnSpan];
            String[] keyColReaderTemplates = new String[idColumnSpan];
            Iterator<Selectable> cItr2 = key.getColumnIterator();
            for (int k2 = 0; k2 < idColumnSpan; ++k2) {
                Column column = (Column)cItr2.next();
                keyCols[k2] = column.getQuotedName(factory.getJdbcServices().getDialect());
                keyColReaders[k2] = column.getReadExpr(factory.getJdbcServices().getDialect());
                keyColReaderTemplates[k2] = column.getTemplate(factory.getJdbcServices().getDialect(), factory.getQueryEngine().getSqmFunctionRegistry());
            }
            keyColumns.add(keyCols);
            keyColumnReaders.add(keyColReaders);
            keyColumnReaderTemplates.add(keyColReaderTemplates);
            cascadeDeletes.add(key.isCascadeDeleteEnabled() && factory.getJdbcServices().getDialect().supportsCascadeDelete());
        }
        this.coreTableSpan = tableNames.size();
        this.tableSpan = persistentClass.getJoinClosureSpan() + this.coreTableSpan;
        this.isNullableTable = new boolean[this.tableSpan];
        this.isInverseTable = new boolean[this.tableSpan];
        Iterator<Join> joinItr = persistentClass.getJoinClosureIterator();
        int tableIndex = 0;
        while (joinItr.hasNext()) {
            Join join = joinItr.next();
            this.isNullableTable[tableIndex] = join.isOptional();
            this.isInverseTable[tableIndex] = join.isInverse();
            Table table = join.getTable();
            String tableName = this.determineTableName(table, jdbcEnvironment);
            tableNames.add(tableName);
            KeyValue key = join.getKey();
            int joinIdColumnSpan = key.getColumnSpan();
            String[] keyCols = new String[joinIdColumnSpan];
            String[] keyColReaders = new String[joinIdColumnSpan];
            String[] keyColReaderTemplates = new String[joinIdColumnSpan];
            cItr = key.getColumnIterator();
            for (k = 0; k < joinIdColumnSpan; ++k) {
                Column column = (Column)cItr.next();
                keyCols[k] = column.getQuotedName(factory.getJdbcServices().getDialect());
                keyColReaders[k] = column.getReadExpr(factory.getJdbcServices().getDialect());
                keyColReaderTemplates[k] = column.getTemplate(factory.getJdbcServices().getDialect(), factory.getQueryEngine().getSqmFunctionRegistry());
            }
            keyColumns.add(keyCols);
            keyColumnReaders.add(keyColReaders);
            keyColumnReaderTemplates.add(keyColReaderTemplates);
            cascadeDeletes.add(key.isCascadeDeleteEnabled() && factory.getJdbcServices().getDialect().supportsCascadeDelete());
            ++tableIndex;
        }
        this.naturalOrderTableNames = ArrayHelper.toStringArray(tableNames);
        this.naturalOrderTableKeyColumns = ArrayHelper.to2DStringArray(keyColumns);
        this.naturalOrderTableKeyColumnReaders = ArrayHelper.to2DStringArray(keyColumnReaders);
        this.naturalOrderTableKeyColumnReaderTemplates = ArrayHelper.to2DStringArray(keyColumnReaderTemplates);
        this.naturalOrderCascadeDeleteEnabled = ArrayHelper.toBooleanArray(cascadeDeletes);
        ArrayList<String> subclassTableNames = new ArrayList<String>();
        ArrayList<Boolean> isConcretes = new ArrayList<Boolean>();
        ArrayList<Boolean> isDeferreds = new ArrayList<Boolean>();
        ArrayList<Boolean> isLazies = new ArrayList<Boolean>();
        ArrayList<Boolean> isInverses = new ArrayList<Boolean>();
        ArrayList<Boolean> isNullables = new ArrayList<Boolean>();
        keyColumns = new ArrayList();
        tItr = persistentClass.getSubclassTableClosureIterator();
        while (tItr.hasNext()) {
            Table tab = tItr.next();
            isConcretes.add(persistentClass.isClassOrSuperclassTable(tab));
            isDeferreds.add(Boolean.FALSE);
            isLazies.add(Boolean.FALSE);
            isInverses.add(Boolean.FALSE);
            isNullables.add(Boolean.FALSE);
            String tableName = this.determineTableName(tab, jdbcEnvironment);
            subclassTableNames.add(tableName);
            String[] key = new String[idColumnSpan];
            cItr = tab.getPrimaryKey().getColumnIterator();
            for (k = 0; k < idColumnSpan; ++k) {
                key[k] = ((Column)cItr.next()).getQuotedName(factory.getJdbcServices().getDialect());
            }
            keyColumns.add(key);
        }
        joinItr = persistentClass.getSubclassJoinClosureIterator();
        while (joinItr.hasNext()) {
            Join join = joinItr.next();
            Table joinTable = join.getTable();
            isConcretes.add(persistentClass.isClassOrSuperclassTable(joinTable));
            isDeferreds.add(join.isSequentialSelect());
            isInverses.add(join.isInverse());
            isNullables.add(join.isOptional());
            isLazies.add(join.isLazy());
            String joinTableName = this.determineTableName(joinTable, jdbcEnvironment);
            subclassTableNames.add(joinTableName);
            String[] key = new String[idColumnSpan];
            Iterator<Column> citer = joinTable.getPrimaryKey().getColumnIterator();
            for (int k3 = 0; k3 < idColumnSpan; ++k3) {
                key[k3] = citer.next().getQuotedName(factory.getJdbcServices().getDialect());
            }
            keyColumns.add(key);
        }
        String[] naturalOrderSubclassTableNameClosure = ArrayHelper.toStringArray(subclassTableNames);
        String[][] naturalOrderSubclassTableKeyColumnClosure = ArrayHelper.to2DStringArray(keyColumns);
        this.isClassOrSuperclassTable = ArrayHelper.toBooleanArray(isConcretes);
        this.subclassTableSequentialSelect = ArrayHelper.toBooleanArray(isDeferreds);
        this.subclassTableIsLazyClosure = ArrayHelper.toBooleanArray(isLazies);
        this.isInverseSubclassTable = ArrayHelper.toBooleanArray(isInverses);
        this.isNullableSubclassTable = ArrayHelper.toBooleanArray(isNullables);
        this.constraintOrderedTableNames = new String[naturalOrderSubclassTableNameClosure.length];
        this.constraintOrderedKeyColumnNames = new String[naturalOrderSubclassTableNameClosure.length][];
        int currentPosition = 0;
        int i = naturalOrderSubclassTableNameClosure.length - 1;
        while (i >= 0) {
            this.constraintOrderedTableNames[currentPosition] = naturalOrderSubclassTableNameClosure[i];
            this.constraintOrderedKeyColumnNames[currentPosition] = naturalOrderSubclassTableKeyColumnClosure[i];
            --i;
            ++currentPosition;
        }
        this.tableNames = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableNames, this.coreTableSpan);
        this.tableKeyColumns = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumns, this.coreTableSpan);
        this.tableKeyColumnReaders = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumnReaders, this.coreTableSpan);
        this.tableKeyColumnReaderTemplates = JoinedSubclassEntityPersister.reverse(this.naturalOrderTableKeyColumnReaderTemplates, this.coreTableSpan);
        this.subclassTableNameClosure = JoinedSubclassEntityPersister.reverse(naturalOrderSubclassTableNameClosure, this.coreTableSpan);
        this.subclassTableKeyColumnClosure = JoinedSubclassEntityPersister.reverse(naturalOrderSubclassTableKeyColumnClosure, this.coreTableSpan);
        this.spaces = ArrayHelper.join(this.tableNames, ArrayHelper.toStringArray(persistentClass.getSynchronizedTables()));
        this.customSQLInsert = new String[this.tableSpan];
        this.customSQLUpdate = new String[this.tableSpan];
        this.customSQLDelete = new String[this.tableSpan];
        this.insertCallable = new boolean[this.tableSpan];
        this.updateCallable = new boolean[this.tableSpan];
        this.deleteCallable = new boolean[this.tableSpan];
        this.insertResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.updateResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        this.deleteResultCheckStyles = new ExecuteUpdateResultCheckStyle[this.tableSpan];
        int jk = this.coreTableSpan - 1;
        for (PersistentClass pc = persistentClass; pc != null; pc = pc.getSuperclass()) {
            this.isNullableTable[jk] = false;
            this.isInverseTable[jk] = false;
            this.customSQLInsert[jk] = pc.getCustomSQLInsert();
            this.insertCallable[jk] = this.customSQLInsert[jk] != null && pc.isCustomInsertCallable();
            this.insertResultCheckStyles[jk] = pc.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[jk], this.insertCallable[jk]) : pc.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[jk] = pc.getCustomSQLUpdate();
            this.updateCallable[jk] = this.customSQLUpdate[jk] != null && pc.isCustomUpdateCallable();
            this.updateResultCheckStyles[jk] = pc.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[jk], this.updateCallable[jk]) : pc.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[jk] = pc.getCustomSQLDelete();
            this.deleteCallable[jk] = this.customSQLDelete[jk] != null && pc.isCustomDeleteCallable();
            this.deleteResultCheckStyles[jk] = pc.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[jk], this.deleteCallable[jk]) : pc.getCustomSQLDeleteCheckStyle();
            --jk;
        }
        if (jk != -1) {
            throw new AssertionFailure("Tablespan does not match height of joined-subclass hiearchy.");
        }
        joinItr = persistentClass.getJoinClosureIterator();
        int j = this.coreTableSpan;
        while (joinItr.hasNext()) {
            Join join = joinItr.next();
            this.isInverseTable[j] = join.isInverse();
            this.isNullableTable[j] = join.isOptional();
            this.customSQLInsert[j] = join.getCustomSQLInsert();
            this.insertCallable[j] = this.customSQLInsert[j] != null && join.isCustomInsertCallable();
            this.insertResultCheckStyles[j] = join.getCustomSQLInsertCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLInsert[j], this.insertCallable[j]) : join.getCustomSQLInsertCheckStyle();
            this.customSQLUpdate[j] = join.getCustomSQLUpdate();
            this.updateCallable[j] = this.customSQLUpdate[j] != null && join.isCustomUpdateCallable();
            this.updateResultCheckStyles[j] = join.getCustomSQLUpdateCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLUpdate[j], this.updateCallable[j]) : join.getCustomSQLUpdateCheckStyle();
            this.customSQLDelete[j] = join.getCustomSQLDelete();
            this.deleteCallable[j] = this.customSQLDelete[j] != null && join.isCustomDeleteCallable();
            this.deleteResultCheckStyles[j] = join.getCustomSQLDeleteCheckStyle() == null ? ExecuteUpdateResultCheckStyle.determineDefault(this.customSQLDelete[j], this.deleteCallable[j]) : join.getCustomSQLDeleteCheckStyle();
            ++j;
        }
        int hydrateSpan = this.getPropertySpan();
        this.naturalOrderPropertyTableNumbers = new int[hydrateSpan];
        this.propertyTableNumbers = new int[hydrateSpan];
        Iterator<Property> iter = persistentClass.getPropertyClosureIterator();
        int i2 = 0;
        while (iter.hasNext()) {
            Property prop = iter.next();
            String tabname = prop.getValue().getTable().getQualifiedName(factory.getJdbcServices().getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            this.propertyTableNumbers[i2] = JoinedSubclassEntityPersister.getTableId(tabname, this.tableNames);
            this.naturalOrderPropertyTableNumbers[i2] = JoinedSubclassEntityPersister.getTableId(tabname, this.naturalOrderTableNames);
            ++i2;
        }
        ArrayList<Integer> columnTableNumbers = new ArrayList<Integer>();
        ArrayList<Integer> formulaTableNumbers = new ArrayList<Integer>();
        ArrayList<Integer> propTableNumbers = new ArrayList<Integer>();
        iter = persistentClass.getSubclassPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = iter.next();
            Table tab = prop.getValue().getTable();
            String tabname = tab.getQualifiedName(factory.getJdbcServices().getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            Integer tabnum = JoinedSubclassEntityPersister.getTableId(tabname, this.subclassTableNameClosure);
            propTableNumbers.add(tabnum);
            Iterator<Selectable> citer = prop.getColumnIterator();
            while (citer.hasNext()) {
                Selectable thing = citer.next();
                if (thing.isFormula()) {
                    formulaTableNumbers.add(tabnum);
                    continue;
                }
                columnTableNumbers.add(tabnum);
            }
        }
        this.subclassColumnTableNumberClosure = ArrayHelper.toIntArray(columnTableNumbers);
        this.subclassPropertyTableNumberClosure = ArrayHelper.toIntArray(propTableNumbers);
        this.subclassFormulaTableNumberClosure = ArrayHelper.toIntArray(formulaTableNumbers);
        int subclassSpan = persistentClass.getSubclassSpan() + 1;
        this.subclassClosure = new String[subclassSpan];
        int subclassSpanMinusOne = subclassSpan - 1;
        this.subclassClosure[subclassSpanMinusOne] = this.getEntityName();
        if (persistentClass.isPolymorphic()) {
            this.subclassesByDiscriminatorValue.put(this.discriminatorValue, this.getEntityName());
            this.discriminatorValuesByTableName = CollectionHelper.linkedMapOfSize(subclassSpan + 1);
            this.discriminatorColumnNameByTableName = CollectionHelper.linkedMapOfSize(subclassSpan + 1);
            this.subclassNameByTableName = CollectionHelper.mapOfSize(subclassSpan + 1);
            try {
                int id;
                Table table = persistentClass.getTable();
                Object convertedDiscriminatorValue = this.discriminatorType.getJavaTypeDescriptor().fromString(this.discriminatorSQLString);
                this.discriminatorValues = new String[subclassSpan];
                this.initDiscriminatorProperties(factory, jdbcEnvironment, subclassSpanMinusOne, table, convertedDiscriminatorValue);
                this.notNullColumnTableNumbers = new int[subclassSpan];
                this.notNullColumnTableNumbers[subclassSpanMinusOne] = id = JoinedSubclassEntityPersister.getTableId(table.getQualifiedName(factory.getJdbcServices().getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
                this.notNullColumnNames = new String[subclassSpan];
                this.notNullColumnNames[subclassSpanMinusOne] = this.subclassTableKeyColumnClosure[id][0];
            }
            catch (HibernateException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MappingException("Could not resolve specified discriminator value [" + this.discriminatorSQLString + "] to discriminator type [" + this.discriminatorType + "]");
            }
        } else {
            this.subclassNameByTableName = Collections.emptyMap();
            this.discriminatorValuesByTableName = Collections.emptyMap();
            this.discriminatorColumnNameByTableName = Collections.emptyMap();
            this.discriminatorValues = null;
            this.notNullColumnTableNumbers = null;
            this.notNullColumnNames = null;
        }
        Iterator<Subclass> siter = persistentClass.getSubclassIterator();
        int k4 = 0;
        while (siter.hasNext()) {
            Subclass sc = siter.next();
            this.subclassClosure[k4] = sc.getEntityName();
            Table table = sc.getTable();
            this.subclassNameByTableName.put(table.getName(), sc.getEntityName());
            try {
                if (persistentClass.isPolymorphic()) {
                    int id;
                    Object discriminatorValue;
                    if (this.explicitDiscriminatorColumnName != null) {
                        if (sc.isDiscriminatorValueNull()) {
                            discriminatorValue = NULL_DISCRIMINATOR;
                        } else if (sc.isDiscriminatorValueNotNull()) {
                            discriminatorValue = NOT_NULL_DISCRIMINATOR;
                        } else {
                            try {
                                discriminatorValue = this.discriminatorType.getJavaTypeDescriptor().fromString(sc.getDiscriminatorValue());
                            }
                            catch (ClassCastException cce) {
                                throw new MappingException("Illegal discriminator type: " + this.discriminatorType.getName());
                            }
                            catch (Exception e) {
                                throw new MappingException("Could not format discriminator value to SQL string", e);
                            }
                        }
                    } else {
                        discriminatorValue = sc.getSubclassId();
                    }
                    this.initDiscriminatorProperties(factory, jdbcEnvironment, k4, table, discriminatorValue);
                    this.subclassesByDiscriminatorValue.put(discriminatorValue, sc.getEntityName());
                    this.notNullColumnTableNumbers[k4] = id = JoinedSubclassEntityPersister.getTableId(table.getQualifiedName(factory.getJdbcServices().getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName()), this.subclassTableNameClosure);
                    this.notNullColumnNames[k4] = this.subclassTableKeyColumnClosure[id][0];
                }
            }
            catch (Exception e) {
                throw new MappingException("Error parsing discriminator value", e);
            }
            ++k4;
        }
        this.subclassNamesBySubclassTable = this.buildSubclassNamesBySubclassTableMapping(persistentClass, factory);
        this.initSubclassPropertyAliasesMap(persistentClass);
        this.postConstruct(creationContext.getMetadata());
    }

    private void initDiscriminatorProperties(SessionFactoryImplementor factory, JdbcEnvironment jdbcEnvironment, int k, Table table, Object discriminatorValue) {
        String tableName = this.determineTableName(table, jdbcEnvironment);
        String columnName = table.getPrimaryKey().getColumn(0).getQuotedName(factory.getJdbcServices().getDialect());
        this.discriminatorValuesByTableName.put(tableName, discriminatorValue);
        this.discriminatorColumnNameByTableName.put(tableName, columnName);
        this.discriminatorValues[k] = discriminatorValue.toString();
    }

    private String[][] buildSubclassNamesBySubclassTableMapping(PersistentClass persistentClass, SessionFactoryImplementor factory) {
        int numberOfSubclassTables = this.subclassTableNameClosure.length - this.coreTableSpan;
        if (numberOfSubclassTables == 0) {
            return new String[0][];
        }
        String[][] mapping = new String[numberOfSubclassTables][];
        this.processPersistentClassHierarchy(persistentClass, true, factory, mapping);
        return mapping;
    }

    private Set<String> processPersistentClassHierarchy(PersistentClass persistentClass, boolean isBase, SessionFactoryImplementor factory, String[][] mapping) {
        HashSet<String> classNames = new HashSet<String>();
        Iterator<Subclass> itr = persistentClass.getDirectSubclasses();
        while (itr.hasNext()) {
            Subclass subclass = itr.next();
            Set<String> subclassSubclassNames = this.processPersistentClassHierarchy(subclass, false, factory, mapping);
            classNames.addAll(subclassSubclassNames);
        }
        classNames.add(persistentClass.getEntityName());
        if (!isBase) {
            for (MappedSuperclass msc = persistentClass.getSuperMappedSuperclass(); msc != null; msc = msc.getSuperMappedSuperclass()) {
                classNames.add(msc.getMappedClass().getName());
            }
            this.associateSubclassNamesToSubclassTableIndexes(persistentClass, classNames, mapping, factory);
        }
        return classNames;
    }

    private void associateSubclassNamesToSubclassTableIndexes(PersistentClass persistentClass, Set<String> classNames, String[][] mapping, SessionFactoryImplementor factory) {
        String tableName = persistentClass.getTable().getQualifiedName(factory.getJdbcServices().getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
        this.associateSubclassNamesToSubclassTableIndex(tableName, classNames, mapping);
        Iterator<Join> itr = persistentClass.getJoinIterator();
        while (itr.hasNext()) {
            Join join = itr.next();
            String secondaryTableName = join.getTable().getQualifiedName(factory.getJdbcServices().getDialect(), factory.getSettings().getDefaultCatalogName(), factory.getSettings().getDefaultSchemaName());
            this.associateSubclassNamesToSubclassTableIndex(secondaryTableName, classNames, mapping);
        }
    }

    private void associateSubclassNamesToSubclassTableIndex(String tableName, Set<String> classNames, String[][] mapping) {
        boolean found = false;
        for (int i = 0; i < this.subclassTableNameClosure.length; ++i) {
            if (!this.subclassTableNameClosure[i].equals(tableName)) continue;
            found = true;
            int index = i - this.coreTableSpan;
            if (index < 0 || index >= mapping.length) {
                throw new IllegalStateException(String.format("Encountered 'subclass table index' [%s] was outside expected range ( [%s] < i < [%s] )", index, 0, mapping.length));
            }
            mapping[index] = ArrayHelper.toStringArray(classNames);
            break;
        }
        if (!found) {
            throw new IllegalStateException(String.format("Was unable to locate subclass table [%s] in 'subclassTableNameClosure'", tableName));
        }
    }

    @Override
    public boolean isNullableTable(int j) {
        return this.isNullableTable[j];
    }

    @Override
    public boolean isInverseTable(int j) {
        return this.isInverseTable[j];
    }

    @Override
    protected boolean isSubclassTableSequentialSelect(int j) {
        return this.subclassTableSequentialSelect[j] && !this.isClassOrSuperclassTable[j];
    }

    @Override
    public String getSubclassPropertyTableName(int i) {
        return this.subclassTableNameClosure[this.subclassPropertyTableNumberClosure[i]];
    }

    @Override
    protected boolean isInverseSubclassTable(int j) {
        return this.isInverseSubclassTable[j];
    }

    @Override
    protected boolean isNullableSubclassTable(int j) {
        return this.isNullableSubclassTable[j];
    }

    @Override
    public Type getDiscriminatorType() {
        return this.discriminatorType;
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    @Override
    public String getDiscriminatorSQLValue() {
        return this.discriminatorSQLString;
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.explicitDiscriminatorColumnName == null ? super.getDiscriminatorColumnName() : this.explicitDiscriminatorColumnName;
    }

    @Override
    public String getDiscriminatorColumnReaders() {
        return this.getDiscriminatorColumnName();
    }

    @Override
    public String getDiscriminatorColumnReaderTemplate() {
        return this.getDiscriminatorColumnName();
    }

    @Override
    public String getDiscriminatorAlias() {
        return this.discriminatorAlias;
    }

    @Override
    public String getSubclassForDiscriminatorValue(Object value) {
        if (value == null) {
            return this.subclassesByDiscriminatorValue.get(NULL_DISCRIMINATOR);
        }
        String result = this.subclassesByDiscriminatorValue.get(value);
        if (result == null) {
            result = this.subclassesByDiscriminatorValue.get(NOT_NULL_DISCRIMINATOR);
        }
        return result;
    }

    @Override
    protected void addDiscriminatorToInsert(Insert insert) {
        if (this.explicitDiscriminatorColumnName != null) {
            insert.addColumn(this.explicitDiscriminatorColumnName, this.getDiscriminatorSQLValue());
        }
    }

    @Override
    public Serializable[] getPropertySpaces() {
        return this.spaces;
    }

    @Override
    public String getTableName(int j) {
        return this.naturalOrderTableNames[j];
    }

    @Override
    public String[] getKeyColumns(int j) {
        return this.naturalOrderTableKeyColumns[j];
    }

    @Override
    public boolean isTableCascadeDeleteEnabled(int j) {
        return this.naturalOrderCascadeDeleteEnabled[j];
    }

    @Override
    public boolean isPropertyOfTable(int property, int j) {
        return this.naturalOrderPropertyTableNumbers[property] == j;
    }

    private static String[] reverse(String[] objects, int n) {
        int i;
        int size = objects.length;
        String[] temp = new String[size];
        for (i = 0; i < n; ++i) {
            temp[i] = objects[n - i - 1];
        }
        for (i = n; i < size; ++i) {
            temp[i] = objects[i];
        }
        return temp;
    }

    private static String[][] reverse(String[][] objects, int n) {
        int i;
        int size = objects.length;
        String[][] temp = new String[size][];
        for (i = 0; i < n; ++i) {
            temp[i] = objects[n - i - 1];
        }
        for (i = n; i < size; ++i) {
            temp[i] = objects[i];
        }
        return temp;
    }

    @Override
    public String fromTableFragment(String alias) {
        return this.getTableName() + ' ' + alias;
    }

    @Override
    public String getTableName() {
        return this.tableNames[0];
    }

    private int getRootHierarchyClassTableIndex() {
        String rootHierarchyClassTableName = this.naturalOrderTableNames[0];
        for (int i = 0; i < this.subclassTableNameClosure.length; ++i) {
            if (!this.subclassTableNameClosure[i].equals(rootHierarchyClassTableName)) continue;
            return i;
        }
        return 0;
    }

    @Override
    protected String filterFragment(String alias) {
        return this.hasWhere() ? this.getSQLWhereString(this.generateFilterConditionAlias(alias)) : "";
    }

    @Override
    protected String filterFragment(String alias, Set<String> treatAsDeclarations) {
        return this.filterFragment(alias);
    }

    @Override
    public String generateFilterConditionAlias(String rootAlias) {
        return JoinedSubclassEntityPersister.generateTableAlias(rootAlias, this.tableSpan - 1);
    }

    @Override
    public String[] getIdentifierColumnNames() {
        return this.tableKeyColumns[0];
    }

    @Override
    public String[] getIdentifierColumnReaderTemplates() {
        return this.tableKeyColumnReaderTemplates[0];
    }

    @Override
    public String getRootTableName() {
        return this.naturalOrderTableNames[0];
    }

    @Override
    public String[] getIdentifierColumnReaders() {
        return this.tableKeyColumnReaders[0];
    }

    @Override
    protected int[] getPropertyTableNumbersInSelect() {
        return this.propertyTableNumbers;
    }

    @Override
    protected int getSubclassPropertyTableNumber(int i) {
        return this.subclassPropertyTableNumberClosure[i];
    }

    @Override
    public int getTableSpan() {
        return this.tableSpan;
    }

    @Override
    public boolean isMultiTable() {
        return true;
    }

    @Override
    protected int[] getSubclassColumnTableNumberClosure() {
        return this.subclassColumnTableNumberClosure;
    }

    @Override
    protected int[] getSubclassFormulaTableNumberClosure() {
        return this.subclassFormulaTableNumberClosure;
    }

    @Override
    protected int[] getPropertyTableNumbers() {
        return this.naturalOrderPropertyTableNumbers;
    }

    @Override
    protected String[] getSubclassTableKeyColumns(int j) {
        return this.subclassTableKeyColumnClosure[j];
    }

    @Override
    public String getSubclassTableName(int j) {
        return this.subclassTableNameClosure[j];
    }

    @Override
    protected String[] getSubclassTableNames() {
        return this.subclassTableNameClosure;
    }

    @Override
    public int getSubclassTableSpan() {
        return this.subclassTableNameClosure.length;
    }

    @Override
    protected boolean isSubclassTableLazy(int j) {
        return this.subclassTableIsLazyClosure[j];
    }

    @Override
    protected boolean shouldProcessSuperMapping() {
        return false;
    }

    @Override
    protected boolean isClassOrSuperclassTable(int j) {
        return this.isClassOrSuperclassTable[j];
    }

    @Override
    protected boolean isSubclassTableIndicatedByTreatAsDeclarations(int subclassTableNumber, Set<String> treatAsDeclarations) {
        if (treatAsDeclarations == null || treatAsDeclarations.isEmpty()) {
            return false;
        }
        String[] inclusionSubclassNameClosure = this.getSubclassNameClosureBySubclassTable(subclassTableNumber);
        for (String subclassName : treatAsDeclarations) {
            for (String inclusionSubclassName : inclusionSubclassNameClosure) {
                if (!inclusionSubclassName.equals(subclassName)) continue;
                return true;
            }
        }
        return false;
    }

    private String[] getSubclassNameClosureBySubclassTable(int subclassTableNumber) {
        int index = subclassTableNumber - this.getTableSpan();
        if (index >= this.subclassNamesBySubclassTable.length) {
            throw new IllegalArgumentException("Given subclass table number is outside expected range [" + (this.subclassNamesBySubclassTable.length - 1) + "] as defined by subclassTableNameClosure/subclassClosure");
        }
        return this.subclassNamesBySubclassTable[index];
    }

    @Override
    public String getPropertyTableName(String propertyName) {
        Integer index = this.getEntityMetamodel().getPropertyIndexOrNull(propertyName);
        if (index == null) {
            return null;
        }
        return this.tableNames[this.propertyTableNumbers[index]];
    }

    @Override
    public String[] getConstraintOrderedTableNameClosure() {
        return this.constraintOrderedTableNames;
    }

    @Override
    public String[][] getContraintOrderedTableKeyColumnClosure() {
        return this.constraintOrderedKeyColumnNames;
    }

    @Override
    public String getRootTableAlias(String drivingAlias) {
        return JoinedSubclassEntityPersister.generateTableAlias(drivingAlias, JoinedSubclassEntityPersister.getTableId(this.getRootTableName(), this.tableNames));
    }

    @Override
    public Queryable.Declarer getSubclassPropertyDeclarer(String propertyPath) {
        if ("class".equals(propertyPath)) {
            return Queryable.Declarer.SUBCLASS;
        }
        return super.getSubclassPropertyDeclarer(propertyPath);
    }

    @Override
    public int determineTableNumberForColumn(String columnName) {
        int max = this.naturalOrderTableKeyColumns.length;
        for (int i = 0; i < max; ++i) {
            Object[] keyColumns = this.naturalOrderTableKeyColumns[i];
            if (!ArrayHelper.contains(keyColumns, columnName)) continue;
            return this.naturalOrderPropertyTableNumbers[i];
        }
        String[] subclassColumnNameClosure = this.getSubclassColumnClosure();
        int max2 = subclassColumnNameClosure.length;
        for (int i = 0; i < max2; ++i) {
            boolean quoted;
            boolean bl = quoted = subclassColumnNameClosure[i].startsWith("\"") && subclassColumnNameClosure[i].endsWith("\"");
            if (!(quoted ? subclassColumnNameClosure[i].equals(columnName) : subclassColumnNameClosure[i].equalsIgnoreCase(columnName))) continue;
            return this.getSubclassColumnTableNumberClosure()[i];
        }
        throw new HibernateException("Could not locate table which owns column [" + columnName + "] referenced in order-by mapping");
    }

    @Override
    protected EntityVersionMapping generateVersionMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        if (this.getVersionType() == null) {
            return null;
        }
        if (this.getTableName().equals(this.getVersionedTableName())) {
            int versionPropertyIndex = this.getVersionProperty();
            String versionPropertyName = this.getPropertyNames()[versionPropertyIndex];
            return creationProcess.processSubPart(versionPropertyName, (role, process) -> JoinedSubclassEntityPersister.generateVersionMapping(this, bootEntityDescriptor, process));
        }
        if (this.getSuperMappingType() != null) {
            return this.getSuperMappingType().getVersionMapping();
        }
        return null;
    }

    @Override
    protected EntityIdentifierMapping generateIdentifierMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor) {
        Type idType = this.getIdentifierType();
        if (idType instanceof CompositeType) {
            boolean encapsulated;
            CompositeType cidType = (CompositeType)idType;
            boolean bl = encapsulated = !cidType.isEmbedded();
            if (encapsulated) {
                return MappingModelCreationHelper.buildEncapsulatedCompositeIdentifierMapping(this, bootEntityDescriptor.getIdentifierProperty(), bootEntityDescriptor.getIdentifierProperty().getName(), this.getTableName(), this.tableKeyColumns[0], cidType, creationProcess);
            }
            return this.generateNonEncapsulatedCompositeIdentifierMapping(creationProcess, bootEntityDescriptor, cidType);
        }
        return new BasicEntityIdentifierMappingImpl(this, bootEntityDescriptor.getIdentifierProperty().getName(), this.getTableName(), this.tableKeyColumns[0][0], (BasicType)idType, creationProcess);
    }

    @Override
    protected EntityDiscriminatorMapping generateDiscriminatorMapping(MappingModelCreationProcess modelCreationProcess) {
        EntityMappingType superMappingType = this.getSuperMappingType();
        if (superMappingType != null) {
            return superMappingType.getDiscriminatorMapping();
        }
        if (this.hasSubclasses()) {
            String formula = this.getDiscriminatorFormulaTemplate();
            if (this.explicitDiscriminatorColumnName != null || formula != null) {
                return super.generateDiscriminatorMapping(modelCreationProcess);
            }
            DiscriminatorType discriminatorMetadataType = (DiscriminatorType)this.getTypeDiscriminatorMetadata().getResolutionType();
            return new CaseStatementDiscriminatorMappingImpl(this, this.subclassTableNameClosure, this.notNullColumnTableNumbers, this.notNullColumnNames, this.discriminatorValues, this.subclassNameByTableName, discriminatorMetadataType, modelCreationProcess);
        }
        return null;
    }

    @Override
    protected EntityIdentifierMapping generateNonEncapsulatedCompositeIdentifierMapping(MappingModelCreationProcess creationProcess, PersistentClass bootEntityDescriptor, CompositeType cidType) {
        assert (this.declaredAttributeMappings != null);
        return MappingModelCreationHelper.buildNonEncapsulatedCompositeIdentifierMapping(this, this.getTableName(), this.tableKeyColumns[0], cidType, bootEntityDescriptor, this.declaredAttributeMappings::put, creationProcess);
    }

    @Override
    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new DynamicFilterAliasGenerator(this.subclassTableNameClosure, rootAlias);
    }

    @Override
    public boolean canOmitSuperclassTableJoin() {
        return true;
    }

    @Override
    public <T> DomainResult<T> createDomainResult(NavigablePath navigablePath, TableGroup tableGroup, String resultVariable, DomainResultCreationState creationState) {
        if (this.hasSubclasses()) {
            return new EntityResultJoinedSubclassImpl(navigablePath, this, tableGroup, resultVariable, creationState);
        }
        return super.createDomainResult(navigablePath, tableGroup, resultVariable, creationState);
    }

    @Override
    public void visitConstraintOrderedTables(EntityMappingType.ConstraintOrderedTableConsumer consumer) {
        int i = 0;
        while (i < this.constraintOrderedTableNames.length) {
            String tableName = this.constraintOrderedTableNames[i];
            int tablePosition = i++;
            consumer.consume(tableName, () -> columnConsumer -> columnConsumer.accept(tableName, this.constraintOrderedKeyColumnNames[tablePosition]));
        }
    }

    private CaseSearchedExpressionInfo getCaseSearchedExpression(TableGroup entityTableGroup) {
        CaseSearchedExpressionInfo info = new CaseSearchedExpressionInfo();
        TableReference primaryTableReference = entityTableGroup.getPrimaryTableReference();
        BasicType discriminatorType = (BasicType)this.getDiscriminatorType();
        CaseSearchedExpression caseSearchedExpression = new CaseSearchedExpression(discriminatorType);
        boolean addPrimaryTableCaseAsLastCaseExpression = false;
        for (String tableName : this.discriminatorValuesByTableName.keySet()) {
            if (!primaryTableReference.getTableExpression().equals(tableName)) {
                TableReference tableReference = entityTableGroup.getTableReference(entityTableGroup.getNavigablePath(), tableName);
                if (tableReference == null) {
                    tableReference = entityTableGroup.resolveTableReference(entityTableGroup.getNavigablePath(), tableName);
                }
                ColumnReference identifierColumnReference = this.getIdentifierColumnReference(tableReference);
                info.columnReferences.add(identifierColumnReference);
                this.addWhen(caseSearchedExpression, tableReference, identifierColumnReference, discriminatorType);
                continue;
            }
            addPrimaryTableCaseAsLastCaseExpression = true;
        }
        if (addPrimaryTableCaseAsLastCaseExpression) {
            this.addWhen(caseSearchedExpression, primaryTableReference, this.getIdentifierColumnReference(primaryTableReference), discriminatorType);
        }
        info.caseSearchedExpression = caseSearchedExpression;
        return info;
    }

    private void addWhen(CaseSearchedExpression caseSearchedExpression, TableReference table, ColumnReference identifierColumnReference, BasicType<?> resultType) {
        NullnessPredicate predicate = new NullnessPredicate(identifierColumnReference, true);
        QueryLiteral<Object> expression = new QueryLiteral<Object>(this.discriminatorValuesByTableName.get(table.getTableExpression()), resultType);
        caseSearchedExpression.when(predicate, expression);
    }

    private ColumnReference getIdentifierColumnReference(TableReference tableReference) {
        List<JdbcMapping> jdbcMappings = this.getIdentifierMapping().getJdbcMappings();
        return new ColumnReference(tableReference.getIdentificationVariable(), this.discriminatorColumnNameByTableName.get(tableReference.getTableExpression()), false, null, null, jdbcMappings.get(0), this.getFactory());
    }

    private static class CaseSearchedExpressionInfo {
        CaseSearchedExpression caseSearchedExpression;
        List<ColumnReference> columnReferences = new ArrayList<ColumnReference>();

        private CaseSearchedExpressionInfo() {
        }
    }
}

