/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.hql.internal;

import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.metamodel.model.domain.EntityDomainType;
import org.hibernate.query.hql.HqlLogging;
import org.hibernate.query.hql.spi.SemanticPathPart;
import org.hibernate.query.hql.spi.SqmCreationState;
import org.hibernate.query.sqm.tree.domain.SqmPath;
import org.hibernate.query.sqm.tree.expression.SqmExpression;
import org.hibernate.query.sqm.tree.from.SqmAttributeJoin;
import org.hibernate.query.sqm.tree.from.SqmCrossJoin;
import org.hibernate.query.sqm.tree.from.SqmEntityJoin;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmJoin;
import org.hibernate.query.sqm.tree.from.SqmRoot;

public class DomainPathPart
implements SemanticPathPart {
    private SqmPath<?> currentPath;

    public DomainPathPart(SqmPath<?> basePath) {
        this.currentPath = basePath;
        assert (this.currentPath != null);
    }

    SqmExpression<?> getSqmExpression() {
        return this.currentPath;
    }

    @Override
    public SemanticPathPart resolvePathPart(String name, boolean isTerminal, SqmCreationState creationState) {
        HqlLogging.QUERY_LOGGER.tracef("Resolving DomainPathPart(%s) sub-part : %s", this.currentPath, name);
        SqmPath<?> reusablePath = this.currentPath.getReusablePath(name);
        if (reusablePath != null) {
            this.currentPath = reusablePath;
        } else {
            SqmJoin resolvedPath = null;
            if (this.currentPath instanceof SqmFrom) {
                Object modelPartContainer = null;
                for (SqmJoin sqmJoin : ((SqmFrom)this.currentPath).getSqmJoins()) {
                    SqmAttributeJoin attributeJoin;
                    if (!(sqmJoin instanceof SqmAttributeJoin) || !name.equals(sqmJoin.getReferencedPathSource().getPathName()) || (attributeJoin = (SqmAttributeJoin)sqmJoin).getOn() != null) continue;
                    resolvedPath = sqmJoin;
                    if (!attributeJoin.isFetched()) continue;
                    break;
                }
            }
            this.currentPath = resolvedPath == null ? this.currentPath.get(name) : resolvedPath;
        }
        if (isTerminal) {
            return this.currentPath;
        }
        return this;
    }

    private ModelPartContainer findModelPartContainer(SqmAttributeJoin<?, ?> attributeJoin, SqmCreationState creationState) {
        String entityName;
        SqmPath lhs = attributeJoin.getLhs();
        if (lhs instanceof SqmAttributeJoin) {
            SqmAttributeJoin lhsAttributeJoin = (SqmAttributeJoin)lhs;
            if (lhsAttributeJoin.getReferencedPathSource() instanceof EntityDomainType) {
                String entityName2 = ((EntityDomainType)lhsAttributeJoin.getReferencedPathSource()).getHibernateEntityName();
                return (ModelPartContainer)creationState.getCreationContext().getQueryEngine().getTypeConfiguration().getSessionFactory().getMetamodel().entityPersister(entityName2).findSubPart(attributeJoin.getAttribute().getName(), null);
            }
            return (ModelPartContainer)this.findModelPartContainer(lhsAttributeJoin, creationState).findSubPart(attributeJoin.getAttribute().getName(), null);
        }
        if (lhs instanceof SqmRoot) {
            entityName = ((SqmRoot)lhs).getEntityName();
        } else if (lhs instanceof SqmEntityJoin) {
            entityName = ((SqmEntityJoin)lhs).getEntityName();
        } else {
            assert (lhs instanceof SqmCrossJoin);
            entityName = ((SqmCrossJoin)lhs).getEntityName();
        }
        return (ModelPartContainer)creationState.getCreationContext().getQueryEngine().getTypeConfiguration().getSessionFactory().getMetamodel().entityPersister(entityName).findSubPart(attributeJoin.getAttribute().getName(), null);
    }

    public SqmPath resolveIndexedAccess(SqmExpression selector, boolean isTerminal, SqmCreationState creationState) {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }
}

