/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.TemporalType;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.type.CalendarDateType;
import org.hibernate.type.CalendarTimeType;
import org.hibernate.type.CalendarType;
import org.hibernate.type.InstantType;
import org.hibernate.type.OffsetDateTimeType;
import org.hibernate.type.OffsetTimeType;
import org.hibernate.type.TimestampType;
import org.hibernate.type.ZonedDateTimeType;
import org.hibernate.type.descriptor.java.TemporalJavaTypeDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class BindingTypeHelper {
    public static final BindingTypeHelper INSTANCE = new BindingTypeHelper();

    private BindingTypeHelper() {
    }

    public <T> AllowableParameterType<T> resolveTemporalPrecision(TemporalType precision, AllowableParameterType<T> declaredParameterType, TypeConfiguration typeConfiguration) {
        if (precision != null) {
            if (!(declaredParameterType.getExpressableJavaTypeDescriptor() instanceof TemporalJavaTypeDescriptor)) {
                throw new UnsupportedOperationException("Cannot treat non-temporal parameter type with temporal precision");
            }
            TemporalJavaTypeDescriptor temporalJtd = (TemporalJavaTypeDescriptor)declaredParameterType.getExpressableJavaTypeDescriptor();
            if (temporalJtd.getPrecision() != precision) {
                return typeConfiguration.getBasicTypeRegistry().resolve(temporalJtd.resolveTypeForPrecision(precision, typeConfiguration), TemporalJavaTypeDescriptor.resolveJdbcTypeCode(precision));
            }
        }
        return declaredParameterType;
    }

    public AllowableParameterType determineTypeForTemporalType(TemporalType temporalType, AllowableParameterType baseType, Object bindValue) {
        Class<Object> javaType = bindValue != null ? bindValue.getClass() : (baseType != null ? baseType.getExpressableJavaTypeDescriptor().getJavaTypeClass() : Timestamp.class);
        switch (temporalType) {
            case TIMESTAMP: {
                return this.resolveTimestampTemporalTypeVariant(javaType, baseType);
            }
            case DATE: {
                return this.resolveDateTemporalTypeVariant(javaType, baseType);
            }
            case TIME: {
                return this.resolveTimeTemporalTypeVariant(javaType, baseType);
            }
        }
        throw new IllegalArgumentException("Unexpected TemporalType [" + temporalType + "]; expecting TIMESTAMP, DATE or TIME");
    }

    public JdbcMapping resolveBindType(Object value, JdbcMapping baseType) {
        if (value == null || !(baseType.getJavaTypeDescriptor() instanceof TemporalJavaTypeDescriptor)) {
            return baseType;
        }
        Class<?> javaType = value.getClass();
        TemporalType temporalType = ((TemporalJavaTypeDescriptor)baseType.getJavaTypeDescriptor()).getPrecision();
        switch (temporalType) {
            case TIMESTAMP: {
                return (JdbcMapping)((Object)this.resolveTimestampTemporalTypeVariant(javaType, (AllowableParameterType)((Object)baseType)));
            }
            case DATE: {
                return (JdbcMapping)((Object)this.resolveDateTemporalTypeVariant(javaType, (AllowableParameterType)((Object)baseType)));
            }
            case TIME: {
                return (JdbcMapping)((Object)this.resolveTimeTemporalTypeVariant(javaType, (AllowableParameterType)((Object)baseType)));
            }
        }
        throw new IllegalArgumentException("Unexpected TemporalType [" + temporalType + "]; expecting TIMESTAMP, DATE or TIME");
    }

    public AllowableParameterType resolveTimestampTemporalTypeVariant(Class javaType, AllowableParameterType baseType) {
        if (baseType.getExpressableJavaTypeDescriptor().getJavaTypeClass().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return CalendarType.INSTANCE;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return TimestampType.INSTANCE;
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return InstantType.INSTANCE;
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return OffsetDateTimeType.INSTANCE;
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return ZonedDateTimeType.INSTANCE;
        }
        if (OffsetTime.class.isAssignableFrom(javaType)) {
            return OffsetTimeType.INSTANCE;
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIMESTAMP");
    }

    public AllowableParameterType<?> resolveDateTemporalTypeVariant(Class<?> javaType, AllowableParameterType<?> baseType) {
        if (baseType.getExpressableJavaTypeDescriptor().getJavaTypeClass().isAssignableFrom(javaType)) {
            return baseType;
        }
        if (Calendar.class.isAssignableFrom(javaType)) {
            return CalendarDateType.INSTANCE;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return TimestampType.INSTANCE;
        }
        if (Instant.class.isAssignableFrom(javaType)) {
            return OffsetDateTimeType.INSTANCE;
        }
        if (OffsetDateTime.class.isAssignableFrom(javaType)) {
            return OffsetDateTimeType.INSTANCE;
        }
        if (ZonedDateTime.class.isAssignableFrom(javaType)) {
            return ZonedDateTimeType.INSTANCE;
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#DATE");
    }

    public AllowableParameterType resolveTimeTemporalTypeVariant(Class javaType, AllowableParameterType baseType) {
        if (Calendar.class.isAssignableFrom(javaType)) {
            return CalendarTimeType.INSTANCE;
        }
        if (Date.class.isAssignableFrom(javaType)) {
            return TimestampType.INSTANCE;
        }
        throw new IllegalArgumentException("Unsure how to handle given Java type [" + javaType.getName() + "] as TemporalType#TIME");
    }
}

