/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.internal.ResultSetMappingResolutionContext;
import org.hibernate.query.named.FetchMemento;
import org.hibernate.query.results.FetchBuilder;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.results.graph.Fetchable;
import org.hibernate.sql.results.graph.FetchableContainer;

public class FetchMementoHbmStandard
implements FetchMemento,
FetchMemento.Parent {
    private final NavigablePath navigablePath;
    private final String ownerTableAlias;
    private final String tableAlias;
    private final LockMode lockMode;
    private final FetchParentMemento parent;
    private final Map<String, FetchMemento> fetchMementoMap;
    private final Fetchable fetchable;

    public FetchMementoHbmStandard(NavigablePath navigablePath, String ownerTableAlias, String tableAlias, LockMode lockMode, FetchParentMemento parent, Map<String, FetchMemento> fetchMementoMap, Fetchable fetchable) {
        this.navigablePath = navigablePath;
        this.ownerTableAlias = ownerTableAlias;
        this.tableAlias = tableAlias;
        this.lockMode = lockMode;
        this.parent = parent;
        this.fetchMementoMap = fetchMementoMap;
        this.fetchable = fetchable;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public FetchBuilder resolve(FetchMemento.Parent parent, Consumer<String> querySpaceConsumer, ResultSetMappingResolutionContext context) {
        HashMap<String, FetchBuilder> fetchBuilderMap = new HashMap<String, FetchBuilder>();
        this.fetchMementoMap.forEach((attrName, fetchMemento) -> fetchBuilderMap.put((String)attrName, fetchMemento.resolve(this, querySpaceConsumer, context)));
        return new DynamicFetchBuilderLegacy(this.tableAlias, this.ownerTableAlias, this.fetchable.getFetchableName(), new ArrayList<String>(), fetchBuilderMap);
    }

    public static interface FetchParentMemento {
        public NavigablePath getNavigablePath();

        public FetchableContainer getFetchableContainer();
    }
}

