/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.Parameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.hibernate.QueryException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.spi.ParameterMetadataImplementor;
import org.hibernate.query.spi.QueryParameterImplementor;
import org.hibernate.query.sqm.SqmExpressable;
import org.hibernate.query.sqm.tree.expression.SqmParameter;

public class ParameterMetadataImpl
implements ParameterMetadataImplementor {
    public static final ParameterMetadataImpl EMPTY = new ParameterMetadataImpl();
    private final Map<QueryParameterImplementor<?>, List<SqmParameter>> queryParameters;
    private final Set<String> names;
    private final Set<Integer> labels;

    private ParameterMetadataImpl() {
        this.queryParameters = Collections.emptyMap();
        this.names = Collections.emptySet();
        this.labels = Collections.emptySet();
    }

    public ParameterMetadataImpl(Map<QueryParameterImplementor<?>, List<SqmParameter>> queryParameters) {
        this.queryParameters = queryParameters;
        HashSet<String> names = null;
        HashSet<Integer> labels = null;
        for (QueryParameterImplementor<?> queryParameter : queryParameters.keySet()) {
            if (queryParameter.getPosition() != null) {
                if (labels == null) {
                    labels = new HashSet<Integer>();
                }
                labels.add(queryParameter.getPosition());
                continue;
            }
            if (queryParameter.getName() == null) continue;
            if (names == null) {
                names = new HashSet<String>();
            }
            names.add(queryParameter.getName());
        }
        this.labels = labels == null ? Collections.emptySet() : labels;
        this.names = names == null ? Collections.emptySet() : names;
        ParameterMetadataImpl.verifyOrdinalParamLabels(labels);
    }

    public ParameterMetadataImpl(Map<Integer, QueryParameterImplementor<?>> positionalQueryParameters, Map<String, QueryParameterImplementor<?>> namedQueryParameters) {
        if (CollectionHelper.isEmpty(positionalQueryParameters) && CollectionHelper.isEmpty(namedQueryParameters)) {
            this.queryParameters = Collections.emptyMap();
            this.names = Collections.emptySet();
            this.labels = Collections.emptySet();
        } else {
            this.queryParameters = new IdentityHashMap();
            if (positionalQueryParameters != null) {
                for (QueryParameterImplementor<?> value : positionalQueryParameters.values()) {
                    this.queryParameters.put(value, Collections.emptyList());
                }
                this.labels = positionalQueryParameters.keySet();
                ParameterMetadataImpl.verifyOrdinalParamLabels(this.labels);
            } else {
                this.labels = null;
            }
            if (namedQueryParameters != null) {
                for (QueryParameterImplementor<?> value : namedQueryParameters.values()) {
                    this.queryParameters.put(value, Collections.emptyList());
                }
                this.names = namedQueryParameters.keySet();
            } else {
                this.names = null;
            }
        }
    }

    private static void verifyOrdinalParamLabels(Set<Integer> labels) {
        if (CollectionHelper.isEmpty(labels)) {
            return;
        }
        ArrayList<Integer> sortedLabels = new ArrayList<Integer>(labels);
        sortedLabels.sort(ComparableComparator.instance());
        int lastPosition = -1;
        for (Integer sortedPosition : sortedLabels) {
            if (lastPosition == -1) {
                if (sortedPosition != 1) {
                    throw new QueryException(String.format(Locale.ROOT, "Expected ordinal parameter labels to start with 1, but found - %s", sortedPosition));
                }
                lastPosition = sortedPosition;
                continue;
            }
            if (sortedPosition != lastPosition + 1) {
                throw new QueryException(String.format(Locale.ROOT, "Unexpected gap in ordinal parameter labels [%s -> %s] : [%s]", lastPosition, sortedPosition, StringHelper.join(",", sortedLabels.iterator())));
            }
            lastPosition = sortedPosition;
        }
    }

    @Override
    public int getParameterCount() {
        return this.queryParameters.size();
    }

    @Override
    public <T> AllowableParameterType<T> getInferredParameterType(QueryParameter<T> parameter) {
        List<SqmParameter> sqmParameters = this.queryParameters.get(parameter);
        if (sqmParameters == null || sqmParameters.isEmpty()) {
            return null;
        }
        for (SqmParameter sqmParameter : sqmParameters) {
            SqmExpressable nodeType = sqmParameter.getNodeType();
            if (nodeType == null) continue;
            return nodeType;
        }
        return null;
    }

    @Override
    public boolean containsReference(QueryParameter<?> parameter) {
        return this.queryParameters.containsKey(parameter);
    }

    @Override
    public void visitParameters(Consumer<QueryParameterImplementor<?>> consumer) {
        this.queryParameters.keySet().forEach(consumer);
    }

    public Set<QueryParameterImplementor<?>> getRegistrations() {
        return Collections.unmodifiableSet(this.queryParameters.keySet());
    }

    @Override
    public boolean hasAnyMatching(Predicate<QueryParameterImplementor<?>> filter) {
        for (QueryParameterImplementor<?> queryParameter : this.queryParameters.keySet()) {
            if (!filter.test(queryParameter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public QueryParameterImplementor<?> resolve(Parameter param) {
        if (param instanceof QueryParameterImplementor) {
            return (QueryParameterImplementor)param;
        }
        throw new IllegalArgumentException("Could not resolve jakarta.persistence.Parameter to org.hibernate.query.QueryParameter");
    }

    @Override
    public boolean hasNamedParameters() {
        return !this.names.isEmpty();
    }

    @Override
    public Set<String> getNamedParameterNames() {
        return this.names;
    }

    @Override
    public QueryParameterImplementor<?> getQueryParameter(String name) {
        for (QueryParameterImplementor<?> queryParameter : this.queryParameters.keySet()) {
            if (!name.equals(queryParameter.getName())) continue;
            return queryParameter;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not locate named parameter [%s], expecting one of [%s]", name, String.join((CharSequence)", ", this.names)));
    }

    @Override
    public boolean hasPositionalParameters() {
        return !this.labels.isEmpty();
    }

    @Override
    public Set<Integer> getOrdinalParameterLabels() {
        return this.labels;
    }

    @Override
    public QueryParameterImplementor<?> getQueryParameter(int positionLabel) {
        for (QueryParameterImplementor<?> queryParameter : this.queryParameters.keySet()) {
            if (queryParameter.getPosition() == null || queryParameter.getPosition() != positionLabel) continue;
            return queryParameter;
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Could not locate ordinal parameter [%s], expecting one of [%s]", positionLabel, StringHelper.join(", ", this.labels)));
    }
}

