/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.internal;

import jakarta.persistence.TemporalType;
import java.util.Collection;
import java.util.Iterator;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMapping;
import org.hibernate.metamodel.mapping.MappingModelExpressable;
import org.hibernate.metamodel.model.domain.AllowableParameterType;
import org.hibernate.query.QueryParameter;
import org.hibernate.query.internal.BindingTypeHelper;
import org.hibernate.query.spi.QueryParameterBinding;
import org.hibernate.query.spi.QueryParameterBindingTypeResolver;
import org.hibernate.query.spi.QueryParameterBindingValidator;
import org.hibernate.type.descriptor.java.CoercionException;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public class QueryParameterBindingImpl<T>
implements QueryParameterBinding<T>,
JavaType.CoercionContext {
    private final QueryParameter<T> queryParameter;
    private final QueryParameterBindingTypeResolver typeResolver;
    private final boolean isBindingValidationRequired;
    private boolean isBound;
    private boolean isMultiValued;
    private AllowableParameterType<T> bindType;
    private MappingModelExpressable<T> type;
    private TemporalType explicitTemporalPrecision;
    private T bindValue;
    private Collection<T> bindValues;

    public QueryParameterBindingImpl(QueryParameter<T> queryParameter, QueryParameterBindingTypeResolver typeResolver, boolean isBindingValidationRequired) {
        this.queryParameter = queryParameter;
        this.typeResolver = typeResolver;
        this.isBindingValidationRequired = isBindingValidationRequired;
        this.bindType = queryParameter.getHibernateType();
    }

    public QueryParameterBindingImpl(QueryParameter<T> queryParameter, QueryParameterBindingTypeResolver typeResolver, AllowableParameterType<T> bindType, boolean isBindingValidationRequired) {
        this.queryParameter = queryParameter;
        this.typeResolver = typeResolver;
        this.isBindingValidationRequired = isBindingValidationRequired;
        this.bindType = bindType;
    }

    @Override
    public AllowableParameterType<T> getBindType() {
        return this.bindType;
    }

    @Override
    public TemporalType getExplicitTemporalPrecision() {
        return this.explicitTemporalPrecision;
    }

    @Override
    public boolean isBound() {
        return this.isBound;
    }

    @Override
    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    @Override
    public T getBindValue() {
        if (this.isMultiValued) {
            throw new IllegalStateException("Binding is multi-valued; illegal call to #getBindValue");
        }
        return this.bindValue;
    }

    @Override
    public void setBindValue(T value, boolean resolveJdbcTypeIfNecessary) {
        if (this.handleAsMultiValue(value)) {
            return;
        }
        if (!this.getTypeConfiguration().getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled()) {
            try {
                if (this.bindType != null) {
                    value = this.bindType.getExpressableJavaTypeDescriptor().coerce(value, this);
                } else if (this.queryParameter.getHibernateType() != null) {
                    value = this.queryParameter.getHibernateType().getExpressableJavaTypeDescriptor().coerce(value, this);
                }
            }
            catch (CoercionException ce) {
                throw new IllegalArgumentException(String.format("Parameter value [%s] did not match expected type [%s ]", value, this.bindType.getTypeName()), (Throwable)((Object)ce));
            }
        }
        if (this.isBindingValidationRequired) {
            this.validate(value);
        }
        if (resolveJdbcTypeIfNecessary && this.bindType == null && value == null) {
            this.bindType = this.getTypeConfiguration().getBasicTypeRegistry().getRegisteredType("null");
        }
        this.bindValue(value);
    }

    private boolean handleAsMultiValue(T value) {
        if (!this.queryParameter.allowsMultiValuedBinding()) {
            return false;
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Collection && !this.isRegisteredAsBasicType(value.getClass())) {
            this.setBindValues((Collection)value);
            return true;
        }
        return false;
    }

    private boolean isRegisteredAsBasicType(Class<?> valueClass) {
        return this.getTypeConfiguration().getBasicTypeForJavaType(valueClass) != null;
    }

    private void bindValue(T value) {
        this.isBound = true;
        this.bindValue = value;
        if (this.bindType == null && value != null) {
            this.bindType = this.typeResolver.resolveParameterBindType(value);
        }
    }

    @Override
    public void setBindValue(T value, AllowableParameterType<T> clarifiedType) {
        if (this.handleAsMultiValue(value)) {
            return;
        }
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
        if (!this.getTypeConfiguration().getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled()) {
            if (this.bindType != null) {
                value = this.bindType.getExpressableJavaTypeDescriptor().coerce(value, this);
            } else if (this.queryParameter.getHibernateType() != null) {
                value = this.queryParameter.getHibernateType().getExpressableJavaTypeDescriptor().coerce(value, this);
            }
        }
        if (this.isBindingValidationRequired) {
            this.validate(value, clarifiedType);
        }
        this.bindValue(value);
    }

    @Override
    public void setBindValue(T value, TemporalType temporalTypePrecision) {
        if (this.handleAsMultiValue(value)) {
            return;
        }
        if (this.bindType == null) {
            this.bindType = this.queryParameter.getHibernateType();
        }
        if (!this.getTypeConfiguration().getSessionFactory().getJpaMetamodel().getJpaCompliance().isLoadByIdComplianceEnabled()) {
            if (this.bindType != null) {
                try {
                    value = this.bindType.getExpressableJavaTypeDescriptor().coerce(value, this);
                }
                catch (CoercionException ex) {
                    throw new IllegalArgumentException(String.format("Parameter value [%s] did not match expected type [%s (%s)]", value, this.bindType.getTypeName(), temporalTypePrecision == null ? "n/a" : temporalTypePrecision.name()), (Throwable)((Object)ex));
                }
            } else if (this.queryParameter.getHibernateType() != null) {
                value = this.queryParameter.getHibernateType().getExpressableJavaTypeDescriptor().coerce(value, this);
            }
        }
        if (this.isBindingValidationRequired) {
            this.validate(value, temporalTypePrecision);
        }
        this.bindValue(value);
        if (this.bindType != null) {
            this.bindType = BindingTypeHelper.INSTANCE.resolveDateTemporalTypeVariant(this.bindType.getExpressableJavaTypeDescriptor().getJavaTypeClass(), this.bindType);
        }
        this.explicitTemporalPrecision = temporalTypePrecision;
    }

    @Override
    public Collection<T> getBindValues() {
        if (!this.isMultiValued) {
            throw new IllegalStateException("Binding is not multi-valued; illegal call to #getBindValues");
        }
        return this.bindValues;
    }

    @Override
    public void setBindValues(Collection<T> values) {
        this.isBound = true;
        this.isMultiValued = true;
        this.bindValue = null;
        this.bindValues = values;
        Iterator<T> iterator = values.iterator();
        Object value = null;
        while (value == null && iterator.hasNext()) {
            value = iterator.next();
        }
        if (this.bindType == null && value != null) {
            this.bindType = this.typeResolver.resolveParameterBindType((Object)value);
        }
    }

    @Override
    public void setBindValues(Collection<T> values, AllowableParameterType<T> clarifiedType) {
        if (clarifiedType != null) {
            this.bindType = clarifiedType;
        }
        this.setBindValues(values);
    }

    @Override
    public void setBindValues(Collection<T> values, TemporalType temporalTypePrecision, TypeConfiguration typeConfiguration) {
        this.setBindValues(values);
        this.bindType = BindingTypeHelper.INSTANCE.resolveTemporalPrecision(temporalTypePrecision, this.bindType, this.getTypeConfiguration());
        this.explicitTemporalPrecision = temporalTypePrecision;
    }

    @Override
    public MappingModelExpressable getType() {
        return this.type;
    }

    @Override
    public boolean setType(MappingModelExpressable type) {
        this.type = type;
        if (this.bindType == null || this.bindType.getJavaType() == Object.class) {
            JdbcMapping jdbcMapping;
            if (type instanceof AllowableParameterType) {
                boolean changed = this.bindType != null && type != this.bindType;
                this.bindType = (AllowableParameterType)((Object)type);
                return changed;
            }
            if (type instanceof BasicValuedMapping && (jdbcMapping = ((BasicValuedMapping)type).getJdbcMapping()) instanceof AllowableParameterType) {
                boolean changed = this.bindType != null && jdbcMapping != this.bindType;
                this.bindType = (AllowableParameterType)((Object)jdbcMapping);
                return changed;
            }
        }
        return false;
    }

    private void validate(T value) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value);
    }

    private void validate(T value, AllowableParameterType clarifiedType) {
        QueryParameterBindingValidator.INSTANCE.validate(clarifiedType, value);
    }

    private void validate(T value, TemporalType clarifiedTemporalType) {
        QueryParameterBindingValidator.INSTANCE.validate(this.getBindType(), value, clarifiedTemporalType);
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.typeResolver.getTypeConfiguration();
    }
}

