/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.metamodel.mapping.ModelPartContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class TableGroupImpl
implements TableGroup {
    private final NavigablePath navigablePath;
    private final String alias;
    private final TableReference primaryTableReference;
    private List<TableGroupJoin> tableGroupJoins;
    private final ModelPartContainer container;
    private final String sourceAlias;

    public TableGroupImpl(NavigablePath navigablePath, String alias, TableReference primaryTableReference, ModelPartContainer container, String sourceAlias) {
        this.navigablePath = navigablePath;
        this.alias = alias;
        this.primaryTableReference = primaryTableReference;
        this.container = container;
        this.sourceAlias = sourceAlias;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public String getGroupAlias() {
        return this.alias;
    }

    @Override
    public ModelPartContainer getModelPart() {
        return this.container;
    }

    @Override
    public ModelPartContainer getExpressionType() {
        return this.getModelPart();
    }

    @Override
    public String getSourceAlias() {
        return this.sourceAlias;
    }

    @Override
    public List<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptyList() : Collections.unmodifiableList(this.tableGroupJoins);
    }

    @Override
    public boolean canUseInnerJoins() {
        return false;
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroupJoins != null && !this.tableGroupJoins.isEmpty();
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new ArrayList<TableGroupJoin>();
        }
        if (!this.tableGroupJoins.contains(join)) {
            this.tableGroupJoins.add(join);
        }
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.primaryTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return Collections.emptyList();
    }

    @Override
    public TableReference resolveTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        TableReference tableReference = this.getTableReference(navigablePath, tableExpression, allowFkOptimization);
        if (tableReference == null) {
            throw new IllegalStateException("Could not resolve binding for table `" + tableExpression + "`");
        }
        return tableReference;
    }

    @Override
    public TableReference getTableReference(NavigablePath navigablePath, String tableExpression, boolean allowFkOptimization) {
        if (this.primaryTableReference.getTableReference(navigablePath, tableExpression, allowFkOptimization) != null) {
            return this.primaryTableReference;
        }
        for (TableGroupJoin tableGroupJoin : this.getTableGroupJoins()) {
            TableReference primaryTableReference = tableGroupJoin.getJoinedGroup().getPrimaryTableReference();
            if (primaryTableReference.getTableReference(navigablePath, tableExpression, allowFkOptimization) == null) continue;
            return primaryTableReference;
        }
        return null;
    }
}

