/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.function.BiFunction;
import org.hibernate.metamodel.mapping.BasicValuedModelPart;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.complete.CompleteResultBuilderBasicValued;
import org.hibernate.query.results.complete.ModelPartReferenceBasic;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.graph.basic.BasicResult;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteResultBuilderBasicModelPart
implements CompleteResultBuilderBasicValued,
ModelPartReferenceBasic {
    private final NavigablePath navigablePath;
    private final BasicValuedModelPart modelPart;
    private final String columnAlias;

    public CompleteResultBuilderBasicModelPart(NavigablePath navigablePath, BasicValuedModelPart modelPart, String columnAlias) {
        this.navigablePath = navigablePath;
        this.modelPart = modelPart;
        this.columnAlias = columnAlias;
    }

    @Override
    public Class<?> getJavaType() {
        return this.modelPart.getExpressableJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public BasicValuedModelPart getReferencedPart() {
        return this.modelPart;
    }

    @Override
    public BasicResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        TableGroup tableGroup = creationStateImpl.getFromClauseAccess().getTableGroup(this.navigablePath.getParent());
        TableReference tableReference = tableGroup.getTableReference(this.navigablePath, this.modelPart.getContainingTableExpression());
        String mappedColumn = this.modelPart.getSelectionExpression();
        SqlSelection sqlSelection = creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableReference, mappedColumn), processingState -> {
            int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(this.columnAlias);
            int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
            return new SqlSelectionImpl(valuesArrayPosition, this.modelPart);
        }), this.modelPart.getJavaTypeDescriptor(), creationStateImpl.getSessionFactory().getTypeConfiguration());
        return new BasicResult(sqlSelection.getValuesArrayPosition(), this.columnAlias, this.modelPart.getJavaTypeDescriptor());
    }
}

