/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.results.complete;

import java.util.function.BiFunction;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.SelectableConsumer;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.results.DomainResultCreationStateImpl;
import org.hibernate.query.results.FromClauseAccessImpl;
import org.hibernate.query.results.ResultsHelper;
import org.hibernate.query.results.SqlSelectionImpl;
import org.hibernate.query.results.complete.CompleteResultBuilderCollection;
import org.hibernate.query.results.dynamic.DynamicFetchBuilderLegacy;
import org.hibernate.sql.ast.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.DomainResultCreationState;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMetadata;

public class CompleteResultBuilderCollectionStandard
implements CompleteResultBuilderCollection,
NativeQuery.CollectionReturn {
    private final String tableAlias;
    private final NavigablePath navigablePath;
    private final PluralAttributeMapping pluralAttributeDescriptor;
    private final String[] keyColumnNames;
    private final String[] indexColumnNames;
    private final String[] elementColumnNames;

    public CompleteResultBuilderCollectionStandard(String tableAlias, NavigablePath navigablePath, PluralAttributeMapping pluralAttributeDescriptor) {
        this(tableAlias, navigablePath, pluralAttributeDescriptor, null, null, null);
    }

    public CompleteResultBuilderCollectionStandard(String tableAlias, NavigablePath navigablePath, PluralAttributeMapping pluralAttributeDescriptor, String[] keyColumnNames, String[] indexColumnNames, String[] elementColumnNames) {
        this.tableAlias = tableAlias;
        this.navigablePath = navigablePath;
        this.pluralAttributeDescriptor = pluralAttributeDescriptor;
        this.keyColumnNames = keyColumnNames;
        this.indexColumnNames = indexColumnNames;
        this.elementColumnNames = elementColumnNames;
    }

    @Override
    public Class<?> getJavaType() {
        return this.pluralAttributeDescriptor.getExpressableJavaTypeDescriptor().getJavaTypeClass();
    }

    @Override
    public String getTableAlias() {
        return this.tableAlias;
    }

    @Override
    public PluralAttributeMapping getPluralAttribute() {
        return this.pluralAttributeDescriptor;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public DomainResult<?> buildResult(JdbcValuesMetadata jdbcResultsMetadata, int resultPosition, BiFunction<String, String, DynamicFetchBuilderLegacy> legacyFetchResolver, DomainResultCreationState domainResultCreationState) {
        DomainResultCreationStateImpl creationStateImpl = ResultsHelper.impl(domainResultCreationState);
        SessionFactoryImplementor sessionFactory = creationStateImpl.getSessionFactory();
        FromClauseAccessImpl fromClauseAccess = creationStateImpl.getFromClauseAccess();
        TableGroup rootTableGroup = this.pluralAttributeDescriptor.createRootTableGroup(false, this.navigablePath, this.tableAlias, null, creationStateImpl, sessionFactory);
        fromClauseAccess.registerTableGroup(this.navigablePath, rootTableGroup);
        this.resolveSelections(rootTableGroup, this.pluralAttributeDescriptor.getKeyDescriptor(), this.keyColumnNames, jdbcResultsMetadata, creationStateImpl);
        if (this.pluralAttributeDescriptor.getIndexDescriptor() != null) {
            this.resolveSelections(rootTableGroup, this.pluralAttributeDescriptor.getIndexDescriptor(), this.indexColumnNames, jdbcResultsMetadata, creationStateImpl);
        }
        this.resolveSelections(rootTableGroup, this.pluralAttributeDescriptor.getElementDescriptor(), this.elementColumnNames, jdbcResultsMetadata, creationStateImpl);
        return this.pluralAttributeDescriptor.createDomainResult(this.navigablePath, rootTableGroup, null, domainResultCreationState);
    }

    private void resolveSelections(TableGroup tableGroup, ModelPart modelPart, String[] columnNames, JdbcValuesMetadata jdbcResultsMetadata, DomainResultCreationStateImpl creationStateImpl) {
        SelectableConsumer consumer = (selectionIndex, selectableMapping) -> {
            String columnName = columnNames[selectionIndex];
            creationStateImpl.resolveSqlSelection(creationStateImpl.resolveSqlExpression(SqlExpressionResolver.createColumnReferenceKey(tableGroup.getTableReference(selectableMapping.getContainingTableExpression()), selectableMapping.getSelectionExpression()), processingState -> {
                int jdbcPosition = jdbcResultsMetadata.resolveColumnPosition(columnName);
                BasicValuedMapping basicType = (BasicValuedMapping)((Object)selectableMapping.getJdbcMapping());
                int valuesArrayPosition = ResultsHelper.jdbcPositionToValuesArrayPosition(jdbcPosition);
                return new SqlSelectionImpl(valuesArrayPosition, basicType);
            }), selectableMapping.getJdbcMapping().getMappedJavaTypeDescriptor(), creationStateImpl.getSessionFactory().getTypeConfiguration());
        };
        if (modelPart instanceof EntityValuedModelPart) {
            EntityMappingType entityMappingType = ((EntityValuedModelPart)modelPart).getEntityMappingType();
            int index = entityMappingType.getIdentifierMapping().forEachSelectable(consumer);
            if (entityMappingType.getDiscriminatorMapping() != null) {
                index += entityMappingType.getDiscriminatorMapping().forEachSelectable(index, consumer);
            }
            entityMappingType.forEachSelectable(index, consumer);
        } else {
            modelPart.forEachSelectable(consumer);
        }
    }
}

