/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.spi;

import org.hibernate.LockOptions;
import org.hibernate.query.Limit;
import org.hibernate.query.spi.DelegatingQueryOptions;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.exec.internal.DelegatingExecutionContext;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcSelect;

public class SqlOmittingQueryOptions
extends DelegatingQueryOptions {
    private final boolean omitLimit;
    private final boolean omitLocks;

    public SqlOmittingQueryOptions(QueryOptions queryOptions, boolean omitLimit, boolean omitLocks) {
        super(queryOptions);
        this.omitLimit = omitLimit;
        this.omitLocks = omitLocks;
    }

    public static ExecutionContext omitSqlQueryOptions(ExecutionContext context) {
        return SqlOmittingQueryOptions.omitSqlQueryOptions(context, true, true);
    }

    public static ExecutionContext omitSqlQueryOptions(ExecutionContext context, JdbcSelect select) {
        return SqlOmittingQueryOptions.omitSqlQueryOptions(context, !select.usesLimitParameters(), false);
    }

    public static ExecutionContext omitSqlQueryOptions(ExecutionContext context, boolean omitLimit, boolean omitLocks) {
        QueryOptions originalQueryOptions = context.getQueryOptions();
        Limit limit = originalQueryOptions.getLimit();
        if (originalQueryOptions.getLockOptions().isEmpty() ? !omitLimit || limit == null || limit.isEmpty() : !omitLocks && (!omitLimit || limit == null || limit.isEmpty())) {
            return context;
        }
        final SqlOmittingQueryOptions queryOptions = new SqlOmittingQueryOptions(originalQueryOptions, omitLimit, omitLocks);
        return new DelegatingExecutionContext(context){

            @Override
            public QueryOptions getQueryOptions() {
                return queryOptions;
            }
        };
    }

    @Override
    public LockOptions getLockOptions() {
        return this.omitLocks ? LockOptions.NONE : super.getLockOptions();
    }

    @Override
    public Integer getFetchSize() {
        return null;
    }

    @Override
    public Limit getLimit() {
        return this.omitLimit ? Limit.NONE : super.getLimit();
    }

    @Override
    public Integer getFirstRow() {
        return this.omitLimit ? null : super.getFirstRow();
    }

    @Override
    public Integer getMaxRows() {
        return this.omitLimit ? null : super.getMaxRows();
    }

    @Override
    public Limit getEffectiveLimit() {
        return this.omitLimit ? Limit.NONE : super.getEffectiveLimit();
    }

    @Override
    public boolean hasLimit() {
        return this.omitLimit ? false : super.hasLimit();
    }
}

